package dysmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QuerySmsTemplateList invokes the dysmsapi.QuerySmsTemplateList API synchronously
func (client *Client) QuerySmsTemplateList(request *QuerySmsTemplateListRequest) (response *QuerySmsTemplateListResponse, err error) {
	response = CreateQuerySmsTemplateListResponse()
	err = client.DoAction(request, response)
	return
}

// QuerySmsTemplateListWithChan invokes the dysmsapi.QuerySmsTemplateList API asynchronously
func (client *Client) QuerySmsTemplateListWithChan(request *QuerySmsTemplateListRequest) (<-chan *QuerySmsTemplateListResponse, <-chan error) {
	responseChan := make(chan *QuerySmsTemplateListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QuerySmsTemplateList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QuerySmsTemplateListWithCallback invokes the dysmsapi.QuerySmsTemplateList API asynchronously
func (client *Client) QuerySmsTemplateListWithCallback(request *QuerySmsTemplateListRequest, callback func(response *QuerySmsTemplateListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QuerySmsTemplateListResponse
		var err error
		defer close(result)
		response, err = client.QuerySmsTemplateList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QuerySmsTemplateListRequest is the request struct for api QuerySmsTemplateList
type QuerySmsTemplateListRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	PageIndex            requests.Integer `position:"Query" name:"PageIndex"`
	RouteName            string           `position:"Query" name:"RouteName"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// QuerySmsTemplateListResponse is the response struct for api QuerySmsTemplateList
type QuerySmsTemplateListResponse struct {
	*responses.BaseResponse
	RequestId       string              `json:"RequestId" xml:"RequestId"`
	Code            string              `json:"Code" xml:"Code"`
	Message         string              `json:"Message" xml:"Message"`
	TotalCount      int64               `json:"TotalCount" xml:"TotalCount"`
	CurrentPage     int                 `json:"CurrentPage" xml:"CurrentPage"`
	PageSize        int                 `json:"PageSize" xml:"PageSize"`
	SmsTemplateList []SmsStatsResultDTO `json:"SmsTemplateList" xml:"SmsTemplateList"`
}

// CreateQuerySmsTemplateListRequest creates a request to invoke QuerySmsTemplateList API
func CreateQuerySmsTemplateListRequest() (request *QuerySmsTemplateListRequest) {
	request = &QuerySmsTemplateListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dysmsapi", "2017-05-25", "QuerySmsTemplateList", "dysms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQuerySmsTemplateListResponse creates a response to parse from QuerySmsTemplateList response
func CreateQuerySmsTemplateListResponse() (response *QuerySmsTemplateListResponse) {
	response = &QuerySmsTemplateListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
