package eais

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateEaiEcs invokes the eais.CreateEaiEcs API synchronously
func (client *Client) CreateEaiEcs(request *CreateEaiEcsRequest) (response *CreateEaiEcsResponse, err error) {
	response = CreateCreateEaiEcsResponse()
	err = client.DoAction(request, response)
	return
}

// CreateEaiEcsWithChan invokes the eais.CreateEaiEcs API asynchronously
func (client *Client) CreateEaiEcsWithChan(request *CreateEaiEcsRequest) (<-chan *CreateEaiEcsResponse, <-chan error) {
	responseChan := make(chan *CreateEaiEcsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateEaiEcs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateEaiEcsWithCallback invokes the eais.CreateEaiEcs API asynchronously
func (client *Client) CreateEaiEcsWithCallback(request *CreateEaiEcsRequest, callback func(response *CreateEaiEcsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateEaiEcsResponse
		var err error
		defer close(result)
		response, err = client.CreateEaiEcs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateEaiEcsRequest is the request struct for api CreateEaiEcs
type CreateEaiEcsRequest struct {
	*requests.RpcRequest
	ClientToken     string             `position:"Query" name:"ClientToken"`
	SecurityGroupId string             `position:"Query" name:"SecurityGroupId"`
	EaisType        string             `position:"Query" name:"EaisType"`
	ResourceGroupId string             `position:"Query" name:"ResourceGroupId"`
	Ecs             CreateEaiEcsEcs    `position:"Query" name:"Ecs"  type:"Struct"`
	EaisName        string             `position:"Query" name:"EaisName"`
	Tag             *[]CreateEaiEcsTag `position:"Query" name:"Tag"  type:"Repeated"`
	VSwitchId       string             `position:"Query" name:"VSwitchId"`
}

// CreateEaiEcsEcs is a repeated param struct in CreateEaiEcsRequest
type CreateEaiEcsEcs struct {
	Password                string `name:"Password"`
	ImageId                 string `name:"ImageId"`
	SystemDiskCategory      string `name:"SystemDiskCategory"`
	InternetMaxBandwidthOut string `name:"InternetMaxBandwidthOut"`
	Name                    string `name:"Name"`
	SystemDiskSize          string `name:"SystemDiskSize"`
	ZoneId                  string `name:"ZoneId"`
	Type                    string `name:"Type"`
	InternetMaxBandwidthIn  string `name:"InternetMaxBandwidthIn"`
}

// CreateEaiEcsTag is a repeated param struct in CreateEaiEcsRequest
type CreateEaiEcsTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// CreateEaiEcsResponse is the response struct for api CreateEaiEcs
type CreateEaiEcsResponse struct {
	*responses.BaseResponse
	RequestId                    string `json:"RequestId" xml:"RequestId"`
	ElasticAcceleratedInstanceId string `json:"ElasticAcceleratedInstanceId" xml:"ElasticAcceleratedInstanceId"`
	ClientInstanceId             string `json:"ClientInstanceId" xml:"ClientInstanceId"`
}

// CreateCreateEaiEcsRequest creates a request to invoke CreateEaiEcs API
func CreateCreateEaiEcsRequest() (request *CreateEaiEcsRequest) {
	request = &CreateEaiEcsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eais", "2019-06-24", "CreateEaiEcs", "eais", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateEaiEcsResponse creates a response to parse from CreateEaiEcs response
func CreateCreateEaiEcsResponse() (response *CreateEaiEcsResponse) {
	response = &CreateEaiEcsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
