package eais

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetInstanceMetrics invokes the eais.GetInstanceMetrics API synchronously
func (client *Client) GetInstanceMetrics(request *GetInstanceMetricsRequest) (response *GetInstanceMetricsResponse, err error) {
	response = CreateGetInstanceMetricsResponse()
	err = client.DoAction(request, response)
	return
}

// GetInstanceMetricsWithChan invokes the eais.GetInstanceMetrics API asynchronously
func (client *Client) GetInstanceMetricsWithChan(request *GetInstanceMetricsRequest) (<-chan *GetInstanceMetricsResponse, <-chan error) {
	responseChan := make(chan *GetInstanceMetricsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetInstanceMetrics(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetInstanceMetricsWithCallback invokes the eais.GetInstanceMetrics API asynchronously
func (client *Client) GetInstanceMetricsWithCallback(request *GetInstanceMetricsRequest, callback func(response *GetInstanceMetricsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetInstanceMetricsResponse
		var err error
		defer close(result)
		response, err = client.GetInstanceMetrics(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetInstanceMetricsRequest is the request struct for api GetInstanceMetrics
type GetInstanceMetricsRequest struct {
	*requests.RpcRequest
	MetricType string `position:"Query" name:"MetricType"`
	TimeStep   string `position:"Query" name:"TimeStep"`
	EndTime    string `position:"Query" name:"EndTime"`
	StartTime  string `position:"Query" name:"StartTime"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// GetInstanceMetricsResponse is the response struct for api GetInstanceMetrics
type GetInstanceMetricsResponse struct {
	*responses.BaseResponse
	RequestId  string      `json:"RequestId" xml:"RequestId"`
	InstanceId string      `json:"InstanceId" xml:"InstanceId"`
	PodMetrics []PodMetric `json:"PodMetrics" xml:"PodMetrics"`
}

// CreateGetInstanceMetricsRequest creates a request to invoke GetInstanceMetrics API
func CreateGetInstanceMetricsRequest() (request *GetInstanceMetricsRequest) {
	request = &GetInstanceMetricsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eais", "2019-06-24", "GetInstanceMetrics", "eais", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetInstanceMetricsResponse creates a response to parse from GetInstanceMetrics response
func CreateGetInstanceMetricsResponse() (response *GetInstanceMetricsResponse) {
	response = &GetInstanceMetricsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
