package eais

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StopEaisEi invokes the eais.StopEaisEi API synchronously
func (client *Client) StopEaisEi(request *StopEaisEiRequest) (response *StopEaisEiResponse, err error) {
	response = CreateStopEaisEiResponse()
	err = client.DoAction(request, response)
	return
}

// StopEaisEiWithChan invokes the eais.StopEaisEi API asynchronously
func (client *Client) StopEaisEiWithChan(request *StopEaisEiRequest) (<-chan *StopEaisEiResponse, <-chan error) {
	responseChan := make(chan *StopEaisEiResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StopEaisEi(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StopEaisEiWithCallback invokes the eais.StopEaisEi API asynchronously
func (client *Client) StopEaisEiWithCallback(request *StopEaisEiRequest, callback func(response *StopEaisEiResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StopEaisEiResponse
		var err error
		defer close(result)
		response, err = client.StopEaisEi(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StopEaisEiRequest is the request struct for api StopEaisEi
type StopEaisEiRequest struct {
	*requests.RpcRequest
	EiInstanceId string `position:"Query" name:"EiInstanceId"`
}

// StopEaisEiResponse is the response struct for api StopEaisEi
type StopEaisEiResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateStopEaisEiRequest creates a request to invoke StopEaisEi API
func CreateStopEaisEiRequest() (request *StopEaisEiRequest) {
	request = &StopEaisEiRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eais", "2019-06-24", "StopEaisEi", "eais", "openAPI")
	request.Method = requests.POST
	return
}

// CreateStopEaisEiResponse creates a response to parse from StopEaisEi response
func CreateStopEaisEiResponse() (response *StopEaisEiResponse) {
	response = &StopEaisEiResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
