package ebs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDiskMonitorDataList invokes the ebs.DescribeDiskMonitorDataList API synchronously
func (client *Client) DescribeDiskMonitorDataList(request *DescribeDiskMonitorDataListRequest) (response *DescribeDiskMonitorDataListResponse, err error) {
	response = CreateDescribeDiskMonitorDataListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDiskMonitorDataListWithChan invokes the ebs.DescribeDiskMonitorDataList API asynchronously
func (client *Client) DescribeDiskMonitorDataListWithChan(request *DescribeDiskMonitorDataListRequest) (<-chan *DescribeDiskMonitorDataListResponse, <-chan error) {
	responseChan := make(chan *DescribeDiskMonitorDataListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDiskMonitorDataList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDiskMonitorDataListWithCallback invokes the ebs.DescribeDiskMonitorDataList API asynchronously
func (client *Client) DescribeDiskMonitorDataListWithCallback(request *DescribeDiskMonitorDataListRequest, callback func(response *DescribeDiskMonitorDataListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDiskMonitorDataListResponse
		var err error
		defer close(result)
		response, err = client.DescribeDiskMonitorDataList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDiskMonitorDataListRequest is the request struct for api DescribeDiskMonitorDataList
type DescribeDiskMonitorDataListRequest struct {
	*requests.RpcRequest
	StartTime  string `position:"Query" name:"StartTime"`
	Type       string `position:"Query" name:"Type"`
	NextToken  string `position:"Query" name:"NextToken"`
	DiskIds    string `position:"Query" name:"DiskIds"`
	EndTime    string `position:"Query" name:"EndTime"`
	MaxResults string `position:"Query" name:"MaxResults"`
}

// DescribeDiskMonitorDataListResponse is the response struct for api DescribeDiskMonitorDataList
type DescribeDiskMonitorDataListResponse struct {
	*responses.BaseResponse
	RequestId   string            `json:"RequestId" xml:"RequestId"`
	TotalCount  int64             `json:"TotalCount" xml:"TotalCount"`
	NextToken   string            `json:"NextToken" xml:"NextToken"`
	MonitorData []DiskMonitorData `json:"MonitorData" xml:"MonitorData"`
}

// CreateDescribeDiskMonitorDataListRequest creates a request to invoke DescribeDiskMonitorDataList API
func CreateDescribeDiskMonitorDataListRequest() (request *DescribeDiskMonitorDataListRequest) {
	request = &DescribeDiskMonitorDataListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ebs", "2021-07-30", "DescribeDiskMonitorDataList", "ebs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDiskMonitorDataListResponse creates a response to parse from DescribeDiskMonitorDataList response
func CreateDescribeDiskMonitorDataListResponse() (response *DescribeDiskMonitorDataListResponse) {
	response = &DescribeDiskMonitorDataListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
