package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateCdsFileShareLink invokes the ecd.CreateCdsFileShareLink API synchronously
func (client *Client) CreateCdsFileShareLink(request *CreateCdsFileShareLinkRequest) (response *CreateCdsFileShareLinkResponse, err error) {
	response = CreateCreateCdsFileShareLinkResponse()
	err = client.DoAction(request, response)
	return
}

// CreateCdsFileShareLinkWithChan invokes the ecd.CreateCdsFileShareLink API asynchronously
func (client *Client) CreateCdsFileShareLinkWithChan(request *CreateCdsFileShareLinkRequest) (<-chan *CreateCdsFileShareLinkResponse, <-chan error) {
	responseChan := make(chan *CreateCdsFileShareLinkResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateCdsFileShareLink(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateCdsFileShareLinkWithCallback invokes the ecd.CreateCdsFileShareLink API asynchronously
func (client *Client) CreateCdsFileShareLinkWithCallback(request *CreateCdsFileShareLinkRequest, callback func(response *CreateCdsFileShareLinkResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateCdsFileShareLinkResponse
		var err error
		defer close(result)
		response, err = client.CreateCdsFileShareLink(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateCdsFileShareLinkRequest is the request struct for api CreateCdsFileShareLink
type CreateCdsFileShareLinkRequest struct {
	*requests.RpcRequest
	Description     string           `position:"Query" name:"Description"`
	PreviewLimit    requests.Integer `position:"Query" name:"PreviewLimit"`
	DisableDownload requests.Boolean `position:"Query" name:"DisableDownload"`
	DisablePreview  requests.Boolean `position:"Query" name:"DisablePreview"`
	SharePwd        string           `position:"Query" name:"SharePwd"`
	ShareName       string           `position:"Query" name:"ShareName"`
	EndUserId       string           `position:"Query" name:"EndUserId"`
	DisableSave     requests.Boolean `position:"Query" name:"DisableSave"`
	GroupId         string           `position:"Query" name:"GroupId"`
	DownloadLimit   requests.Integer `position:"Query" name:"DownloadLimit"`
	CdsId           string           `position:"Query" name:"CdsId"`
	SaveLimit       requests.Integer `position:"Query" name:"SaveLimit"`
	FileIds         *[]string        `position:"Query" name:"FileIds"  type:"Repeated"`
	Expiration      string           `position:"Query" name:"Expiration"`
}

// CreateCdsFileShareLinkResponse is the response struct for api CreateCdsFileShareLink
type CreateCdsFileShareLinkResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateCreateCdsFileShareLinkRequest creates a request to invoke CreateCdsFileShareLink API
func CreateCreateCdsFileShareLinkRequest() (request *CreateCdsFileShareLinkRequest) {
	request = &CreateCdsFileShareLinkRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "CreateCdsFileShareLink", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateCdsFileShareLinkResponse creates a response to parse from CreateCdsFileShareLink response
func CreateCreateCdsFileShareLinkResponse() (response *CreateCdsFileShareLinkResponse) {
	response = &CreateCdsFileShareLinkResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
