package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyCloudDriveGroups invokes the ecd.ModifyCloudDriveGroups API synchronously
func (client *Client) ModifyCloudDriveGroups(request *ModifyCloudDriveGroupsRequest) (response *ModifyCloudDriveGroupsResponse, err error) {
	response = CreateModifyCloudDriveGroupsResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyCloudDriveGroupsWithChan invokes the ecd.ModifyCloudDriveGroups API asynchronously
func (client *Client) ModifyCloudDriveGroupsWithChan(request *ModifyCloudDriveGroupsRequest) (<-chan *ModifyCloudDriveGroupsResponse, <-chan error) {
	responseChan := make(chan *ModifyCloudDriveGroupsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyCloudDriveGroups(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyCloudDriveGroupsWithCallback invokes the ecd.ModifyCloudDriveGroups API asynchronously
func (client *Client) ModifyCloudDriveGroupsWithCallback(request *ModifyCloudDriveGroupsRequest, callback func(response *ModifyCloudDriveGroupsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyCloudDriveGroupsResponse
		var err error
		defer close(result)
		response, err = client.ModifyCloudDriveGroups(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyCloudDriveGroupsRequest is the request struct for api ModifyCloudDriveGroups
type ModifyCloudDriveGroupsRequest struct {
	*requests.RpcRequest
	TotalSize requests.Integer `position:"Query" name:"TotalSize"`
	GroupId   *[]string        `position:"Query" name:"GroupId"  type:"Repeated"`
	CdsId     string           `position:"Query" name:"CdsId"`
	Status    string           `position:"Query" name:"Status"`
}

// ModifyCloudDriveGroupsResponse is the response struct for api ModifyCloudDriveGroups
type ModifyCloudDriveGroupsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateModifyCloudDriveGroupsRequest creates a request to invoke ModifyCloudDriveGroups API
func CreateModifyCloudDriveGroupsRequest() (request *ModifyCloudDriveGroupsRequest) {
	request = &ModifyCloudDriveGroupsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "ModifyCloudDriveGroups", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyCloudDriveGroupsResponse creates a response to parse from ModifyCloudDriveGroups response
func CreateModifyCloudDriveGroupsResponse() (response *ModifyCloudDriveGroupsResponse) {
	response = &ModifyCloudDriveGroupsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
