package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveFilePermission invokes the ecd.RemoveFilePermission API synchronously
func (client *Client) RemoveFilePermission(request *RemoveFilePermissionRequest) (response *RemoveFilePermissionResponse, err error) {
	response = CreateRemoveFilePermissionResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveFilePermissionWithChan invokes the ecd.RemoveFilePermission API asynchronously
func (client *Client) RemoveFilePermissionWithChan(request *RemoveFilePermissionRequest) (<-chan *RemoveFilePermissionResponse, <-chan error) {
	responseChan := make(chan *RemoveFilePermissionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveFilePermission(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveFilePermissionWithCallback invokes the ecd.RemoveFilePermission API asynchronously
func (client *Client) RemoveFilePermissionWithCallback(request *RemoveFilePermissionRequest, callback func(response *RemoveFilePermissionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveFilePermissionResponse
		var err error
		defer close(result)
		response, err = client.RemoveFilePermission(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveFilePermissionRequest is the request struct for api RemoveFilePermission
type RemoveFilePermissionRequest struct {
	*requests.RpcRequest
	MemberList *[]RemoveFilePermissionMemberList `position:"Query" name:"MemberList"  type:"Json"`
	GroupId    string                            `position:"Query" name:"GroupId"`
	CdsId      string                            `position:"Query" name:"CdsId"`
	EndUserId  string                            `position:"Query" name:"EndUserId"`
	FileId     string                            `position:"Query" name:"FileId"`
}

// RemoveFilePermissionMemberList is a repeated param struct in RemoveFilePermissionRequest
type RemoveFilePermissionMemberList struct {
	RoleId      string                                    `name:"RoleId"`
	CdsIdentity RemoveFilePermissionMemberListCdsIdentity `name:"CdsIdentity" type:"Struct"`
}

// RemoveFilePermissionMemberListCdsIdentity is a repeated param struct in RemoveFilePermissionRequest
type RemoveFilePermissionMemberListCdsIdentity struct {
	Id   string `name:"Id"`
	Type string `name:"Type"`
}

// RemoveFilePermissionResponse is the response struct for api RemoveFilePermission
type RemoveFilePermissionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRemoveFilePermissionRequest creates a request to invoke RemoveFilePermission API
func CreateRemoveFilePermissionRequest() (request *RemoveFilePermissionRequest) {
	request = &RemoveFilePermissionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "RemoveFilePermission", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRemoveFilePermissionResponse creates a response to parse from RemoveFilePermission response
func CreateRemoveFilePermissionResponse() (response *RemoveFilePermissionResponse) {
	response = &RemoveFilePermissionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
