package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetOfficeSiteSsoStatus invokes the ecd.SetOfficeSiteSsoStatus API synchronously
func (client *Client) SetOfficeSiteSsoStatus(request *SetOfficeSiteSsoStatusRequest) (response *SetOfficeSiteSsoStatusResponse, err error) {
	response = CreateSetOfficeSiteSsoStatusResponse()
	err = client.DoAction(request, response)
	return
}

// SetOfficeSiteSsoStatusWithChan invokes the ecd.SetOfficeSiteSsoStatus API asynchronously
func (client *Client) SetOfficeSiteSsoStatusWithChan(request *SetOfficeSiteSsoStatusRequest) (<-chan *SetOfficeSiteSsoStatusResponse, <-chan error) {
	responseChan := make(chan *SetOfficeSiteSsoStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetOfficeSiteSsoStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetOfficeSiteSsoStatusWithCallback invokes the ecd.SetOfficeSiteSsoStatus API asynchronously
func (client *Client) SetOfficeSiteSsoStatusWithCallback(request *SetOfficeSiteSsoStatusRequest, callback func(response *SetOfficeSiteSsoStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetOfficeSiteSsoStatusResponse
		var err error
		defer close(result)
		response, err = client.SetOfficeSiteSsoStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetOfficeSiteSsoStatusRequest is the request struct for api SetOfficeSiteSsoStatus
type SetOfficeSiteSsoStatusRequest struct {
	*requests.RpcRequest
	OfficeSiteId string           `position:"Query" name:"OfficeSiteId"`
	SsoType      string           `position:"Query" name:"SsoType"`
	EnableSso    requests.Boolean `position:"Query" name:"EnableSso"`
}

// SetOfficeSiteSsoStatusResponse is the response struct for api SetOfficeSiteSsoStatus
type SetOfficeSiteSsoStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSetOfficeSiteSsoStatusRequest creates a request to invoke SetOfficeSiteSsoStatus API
func CreateSetOfficeSiteSsoStatusRequest() (request *SetOfficeSiteSsoStatusRequest) {
	request = &SetOfficeSiteSsoStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "SetOfficeSiteSsoStatus", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSetOfficeSiteSsoStatusResponse creates a response to parse from SetOfficeSiteSsoStatus response
func CreateSetOfficeSiteSsoStatusResponse() (response *SetOfficeSiteSsoStatusResponse) {
	response = &SetOfficeSiteSsoStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
