package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetUserProfilePathRules invokes the ecd.SetUserProfilePathRules API synchronously
func (client *Client) SetUserProfilePathRules(request *SetUserProfilePathRulesRequest) (response *SetUserProfilePathRulesResponse, err error) {
	response = CreateSetUserProfilePathRulesResponse()
	err = client.DoAction(request, response)
	return
}

// SetUserProfilePathRulesWithChan invokes the ecd.SetUserProfilePathRules API asynchronously
func (client *Client) SetUserProfilePathRulesWithChan(request *SetUserProfilePathRulesRequest) (<-chan *SetUserProfilePathRulesResponse, <-chan error) {
	responseChan := make(chan *SetUserProfilePathRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetUserProfilePathRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetUserProfilePathRulesWithCallback invokes the ecd.SetUserProfilePathRules API asynchronously
func (client *Client) SetUserProfilePathRulesWithCallback(request *SetUserProfilePathRulesRequest, callback func(response *SetUserProfilePathRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetUserProfilePathRulesResponse
		var err error
		defer close(result)
		response, err = client.SetUserProfilePathRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetUserProfilePathRulesRequest is the request struct for api SetUserProfilePathRules
type SetUserProfilePathRulesRequest struct {
	*requests.RpcRequest
	UserProfileRuleType string                                        `position:"Query" name:"UserProfileRuleType"`
	DesktopGroupId      string                                        `position:"Query" name:"DesktopGroupId"`
	UserProfilePathRule *[]SetUserProfilePathRulesUserProfilePathRule `position:"Query" name:"UserProfilePathRule"  type:"Json"`
}

// SetUserProfilePathRulesUserProfilePathRule is a repeated param struct in SetUserProfilePathRulesRequest
type SetUserProfilePathRulesUserProfilePathRule struct {
	BlackPath  SetUserProfilePathRulesUserProfilePathRuleBlackPath         `name:"BlackPath" type:"Struct"`
	WhitePaths *[]SetUserProfilePathRulesUserProfilePathRuleWhitePathsItem `name:"WhitePaths" type:"Repeated"`
}

// SetUserProfilePathRulesUserProfilePathRuleBlackPath is a repeated param struct in SetUserProfilePathRulesRequest
type SetUserProfilePathRulesUserProfilePathRuleBlackPath struct {
	Path string `name:"Path"`
	Type string `name:"Type"`
}

// SetUserProfilePathRulesUserProfilePathRuleWhitePathsItem is a repeated param struct in SetUserProfilePathRulesRequest
type SetUserProfilePathRulesUserProfilePathRuleWhitePathsItem struct {
	Path string `name:"Path"`
	Type string `name:"Type"`
}

// SetUserProfilePathRulesResponse is the response struct for api SetUserProfilePathRules
type SetUserProfilePathRulesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSetUserProfilePathRulesRequest creates a request to invoke SetUserProfilePathRules API
func CreateSetUserProfilePathRulesRequest() (request *SetUserProfilePathRulesRequest) {
	request = &SetUserProfilePathRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "SetUserProfilePathRules", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSetUserProfilePathRulesResponse creates a response to parse from SetUserProfilePathRules response
func CreateSetUserProfilePathRulesResponse() (response *SetUserProfilePathRulesResponse) {
	response = &SetUserProfilePathRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
