package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCloudAssistantSettings invokes the ecs.DescribeCloudAssistantSettings API synchronously
func (client *Client) DescribeCloudAssistantSettings(request *DescribeCloudAssistantSettingsRequest) (response *DescribeCloudAssistantSettingsResponse, err error) {
	response = CreateDescribeCloudAssistantSettingsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCloudAssistantSettingsWithChan invokes the ecs.DescribeCloudAssistantSettings API asynchronously
func (client *Client) DescribeCloudAssistantSettingsWithChan(request *DescribeCloudAssistantSettingsRequest) (<-chan *DescribeCloudAssistantSettingsResponse, <-chan error) {
	responseChan := make(chan *DescribeCloudAssistantSettingsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCloudAssistantSettings(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCloudAssistantSettingsWithCallback invokes the ecs.DescribeCloudAssistantSettings API asynchronously
func (client *Client) DescribeCloudAssistantSettingsWithCallback(request *DescribeCloudAssistantSettingsRequest, callback func(response *DescribeCloudAssistantSettingsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCloudAssistantSettingsResponse
		var err error
		defer close(result)
		response, err = client.DescribeCloudAssistantSettings(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCloudAssistantSettingsRequest is the request struct for api DescribeCloudAssistantSettings
type DescribeCloudAssistantSettingsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SettingType          *[]string        `position:"Query" name:"SettingType"  type:"Repeated"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeCloudAssistantSettingsResponse is the response struct for api DescribeCloudAssistantSettings
type DescribeCloudAssistantSettingsResponse struct {
	*responses.BaseResponse
	RequestId          string             `json:"RequestId" xml:"RequestId"`
	AgentUpgradeConfig AgentUpgradeConfig `json:"AgentUpgradeConfig" xml:"AgentUpgradeConfig"`
	OssDeliveryConfigs OssDeliveryConfigs `json:"OssDeliveryConfigs" xml:"OssDeliveryConfigs"`
	SlsDeliveryConfigs SlsDeliveryConfigs `json:"SlsDeliveryConfigs" xml:"SlsDeliveryConfigs"`
}

// CreateDescribeCloudAssistantSettingsRequest creates a request to invoke DescribeCloudAssistantSettings API
func CreateDescribeCloudAssistantSettingsRequest() (request *DescribeCloudAssistantSettingsRequest) {
	request = &DescribeCloudAssistantSettingsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "DescribeCloudAssistantSettings", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeCloudAssistantSettingsResponse creates a response to parse from DescribeCloudAssistantSettings response
func CreateDescribeCloudAssistantSettingsResponse() (response *DescribeCloudAssistantSettingsResponse) {
	response = &DescribeCloudAssistantSettingsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
