package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EndTerminalSession invokes the ecs.EndTerminalSession API synchronously
func (client *Client) EndTerminalSession(request *EndTerminalSessionRequest) (response *EndTerminalSessionResponse, err error) {
	response = CreateEndTerminalSessionResponse()
	err = client.DoAction(request, response)
	return
}

// EndTerminalSessionWithChan invokes the ecs.EndTerminalSession API asynchronously
func (client *Client) EndTerminalSessionWithChan(request *EndTerminalSessionRequest) (<-chan *EndTerminalSessionResponse, <-chan error) {
	responseChan := make(chan *EndTerminalSessionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EndTerminalSession(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EndTerminalSessionWithCallback invokes the ecs.EndTerminalSession API asynchronously
func (client *Client) EndTerminalSessionWithCallback(request *EndTerminalSessionRequest, callback func(response *EndTerminalSessionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EndTerminalSessionResponse
		var err error
		defer close(result)
		response, err = client.EndTerminalSession(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EndTerminalSessionRequest is the request struct for api EndTerminalSession
type EndTerminalSessionRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SessionId            string           `position:"Query" name:"SessionId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// EndTerminalSessionResponse is the response struct for api EndTerminalSession
type EndTerminalSessionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateEndTerminalSessionRequest creates a request to invoke EndTerminalSession API
func CreateEndTerminalSessionRequest() (request *EndTerminalSessionRequest) {
	request = &EndTerminalSessionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "EndTerminalSession", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateEndTerminalSessionResponse creates a response to parse from EndTerminalSession response
func CreateEndTerminalSessionResponse() (response *EndTerminalSessionResponse) {
	response = &EndTerminalSessionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
