package eflo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// InitializeVcc invokes the eflo.InitializeVcc API synchronously
func (client *Client) InitializeVcc(request *InitializeVccRequest) (response *InitializeVccResponse, err error) {
	response = CreateInitializeVccResponse()
	err = client.DoAction(request, response)
	return
}

// InitializeVccWithChan invokes the eflo.InitializeVcc API asynchronously
func (client *Client) InitializeVccWithChan(request *InitializeVccRequest) (<-chan *InitializeVccResponse, <-chan error) {
	responseChan := make(chan *InitializeVccResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.InitializeVcc(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// InitializeVccWithCallback invokes the eflo.InitializeVcc API asynchronously
func (client *Client) InitializeVccWithCallback(request *InitializeVccRequest, callback func(response *InitializeVccResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *InitializeVccResponse
		var err error
		defer close(result)
		response, err = client.InitializeVcc(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// InitializeVccRequest is the request struct for api InitializeVcc
type InitializeVccRequest struct {
	*requests.RpcRequest
	ResourceGroupId string `position:"Body" name:"ResourceGroupId"`
}

// InitializeVccResponse is the response struct for api InitializeVcc
type InitializeVccResponse struct {
	*responses.BaseResponse
	Code      int     `json:"Code" xml:"Code"`
	Message   string  `json:"Message" xml:"Message"`
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Content   Content `json:"Content" xml:"Content"`
}

// CreateInitializeVccRequest creates a request to invoke InitializeVcc API
func CreateInitializeVccRequest() (request *InitializeVccRequest) {
	request = &InitializeVccRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eflo", "2022-05-30", "InitializeVcc", "eflo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateInitializeVccResponse creates a response to parse from InitializeVcc response
func CreateInitializeVccResponse() (response *InitializeVccResponse) {
	response = &InitializeVccResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
