package eflo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListVccFlowInfos invokes the eflo.ListVccFlowInfos API synchronously
func (client *Client) ListVccFlowInfos(request *ListVccFlowInfosRequest) (response *ListVccFlowInfosResponse, err error) {
	response = CreateListVccFlowInfosResponse()
	err = client.DoAction(request, response)
	return
}

// ListVccFlowInfosWithChan invokes the eflo.ListVccFlowInfos API asynchronously
func (client *Client) ListVccFlowInfosWithChan(request *ListVccFlowInfosRequest) (<-chan *ListVccFlowInfosResponse, <-chan error) {
	responseChan := make(chan *ListVccFlowInfosResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListVccFlowInfos(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListVccFlowInfosWithCallback invokes the eflo.ListVccFlowInfos API asynchronously
func (client *Client) ListVccFlowInfosWithCallback(request *ListVccFlowInfosRequest, callback func(response *ListVccFlowInfosResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListVccFlowInfosResponse
		var err error
		defer close(result)
		response, err = client.ListVccFlowInfos(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListVccFlowInfosRequest is the request struct for api ListVccFlowInfos
type ListVccFlowInfosRequest struct {
	*requests.RpcRequest
	From       requests.Integer `position:"Body" name:"From"`
	To         requests.Integer `position:"Body" name:"To"`
	VccId      string           `position:"Body" name:"VccId"`
	MetricName string           `position:"Body" name:"MetricName"`
	Direction  string           `position:"Body" name:"Direction"`
}

// ListVccFlowInfosResponse is the response struct for api ListVccFlowInfos
type ListVccFlowInfosResponse struct {
	*responses.BaseResponse
	Code      int     `json:"Code" xml:"Code"`
	Message   string  `json:"Message" xml:"Message"`
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Content   Content `json:"Content" xml:"Content"`
}

// CreateListVccFlowInfosRequest creates a request to invoke ListVccFlowInfos API
func CreateListVccFlowInfosRequest() (request *ListVccFlowInfosRequest) {
	request = &ListVccFlowInfosRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eflo", "2022-05-30", "ListVccFlowInfos", "eflo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListVccFlowInfosResponse creates a response to parse from ListVccFlowInfos response
func CreateListVccFlowInfosResponse() (response *ListVccFlowInfosResponse) {
	response = &ListVccFlowInfosResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
