package ehpcinstant

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateJob invokes the ehpcinstant.CreateJob API synchronously
func (client *Client) CreateJob(request *CreateJobRequest) (response *CreateJobResponse, err error) {
	response = CreateCreateJobResponse()
	err = client.DoAction(request, response)
	return
}

// CreateJobWithChan invokes the ehpcinstant.CreateJob API asynchronously
func (client *Client) CreateJobWithChan(request *CreateJobRequest) (<-chan *CreateJobResponse, <-chan error) {
	responseChan := make(chan *CreateJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateJobWithCallback invokes the ehpcinstant.CreateJob API asynchronously
func (client *Client) CreateJobWithCallback(request *CreateJobRequest, callback func(response *CreateJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateJobResponse
		var err error
		defer close(result)
		response, err = client.CreateJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateJobRequest is the request struct for api CreateJob
type CreateJobRequest struct {
	*requests.RpcRequest
	MonitorPolicy    CreateJobMonitorPolicy    `position:"Query" name:"MonitorPolicy"  type:"Struct"`
	JobDescription   string                    `position:"Query" name:"JobDescription"`
	DeploymentPolicy CreateJobDeploymentPolicy `position:"Query" name:"DeploymentPolicy"  type:"Struct"`
	JobName          string                    `position:"Query" name:"JobName"`
	Tasks            *[]CreateJobTasks         `position:"Query" name:"Tasks"  type:"Json"`
}

// CreateJobTasks is a repeated param struct in CreateJobRequest
type CreateJobTasks struct {
	TaskSustainable string                       `name:"TaskSustainable"`
	TaskName        string                       `name:"TaskName"`
	ExecutorPolicy  CreateJobTasksExecutorPolicy `name:"ExecutorPolicy" type:"Struct"`
	TaskSpec        CreateJobTasksTaskSpec       `name:"TaskSpec" type:"Struct"`
}

// CreateJobTasksExecutorPolicy is a repeated param struct in CreateJobRequest
type CreateJobTasksExecutorPolicy struct {
	MaxCount  string                                `name:"MaxCount"`
	ArraySpec CreateJobTasksExecutorPolicyArraySpec `name:"ArraySpec" type:"Struct"`
}

// CreateJobTasksTaskSpec is a repeated param struct in CreateJobRequest
type CreateJobTasksTaskSpec struct {
	VolumeMount  *[]CreateJobTasksTaskSpecVolumeMountItem  `name:"VolumeMount" type:"Repeated"`
	RetryPolicy  CreateJobTasksTaskSpecRetryPolicy         `name:"RetryPolicy" type:"Struct"`
	Resource     CreateJobTasksTaskSpecResource            `name:"Resource" type:"Struct"`
	TaskDuration string                                    `name:"TaskDuration"`
	TaskExecutor *[]CreateJobTasksTaskSpecTaskExecutorItem `name:"TaskExecutor" type:"Repeated"`
}

// CreateJobTasksExecutorPolicyArraySpec is a repeated param struct in CreateJobRequest
type CreateJobTasksExecutorPolicyArraySpec struct {
	IndexStart string `name:"IndexStart"`
	IndexStep  string `name:"IndexStep"`
	IndexEnd   string `name:"IndexEnd"`
}

// CreateJobTasksTaskSpecVolumeMountItem is a repeated param struct in CreateJobRequest
type CreateJobTasksTaskSpecVolumeMountItem struct {
	MountOptions string `name:"MountOptions"`
	VolumeDriver string `name:"VolumeDriver"`
	MountPath    string `name:"MountPath"`
}

// CreateJobTasksTaskSpecRetryPolicy is a repeated param struct in CreateJobRequest
type CreateJobTasksTaskSpecRetryPolicy struct {
	RetryCount      string                                                  `name:"RetryCount"`
	ExitCodeActions *[]CreateJobTasksTaskSpecRetryPolicyExitCodeActionsItem `name:"ExitCodeActions" type:"Repeated"`
}

// CreateJobTasksTaskSpecResource is a repeated param struct in CreateJobRequest
type CreateJobTasksTaskSpecResource struct {
	Cores    string                                     `name:"Cores"`
	Memory   string                                     `name:"Memory"`
	Disks    *[]CreateJobTasksTaskSpecResourceDisksItem `name:"Disks" type:"Repeated"`
	EnableHT string                                     `name:"EnableHT"`
}

// CreateJobTasksTaskSpecTaskExecutorItem is a repeated param struct in CreateJobRequest
type CreateJobTasksTaskSpecTaskExecutorItem struct {
	Container CreateJobTasksTaskSpecTaskExecutorItemContainer `name:"Container" type:"Struct"`
	VM        CreateJobTasksTaskSpecTaskExecutorItemVM        `name:"VM" type:"Struct"`
}

// CreateJobTasksTaskSpecRetryPolicyExitCodeActionsItem is a repeated param struct in CreateJobRequest
type CreateJobTasksTaskSpecRetryPolicyExitCodeActionsItem struct {
	Action   string `name:"Action"`
	ExitCode string `name:"ExitCode"`
}

// CreateJobTasksTaskSpecResourceDisksItem is a repeated param struct in CreateJobRequest
type CreateJobTasksTaskSpecResourceDisksItem struct {
	Size string `name:"Size"`
	Type string `name:"Type"`
}

// CreateJobTasksTaskSpecTaskExecutorItemContainer is a repeated param struct in CreateJobRequest
type CreateJobTasksTaskSpecTaskExecutorItemContainer struct {
	Image           string                                                                `name:"Image"`
	EnvironmentVars *[]CreateJobTasksTaskSpecTaskExecutorItemContainerEnvironmentVarsItem `name:"EnvironmentVars" type:"Repeated"`
	WorkingDir      string                                                                `name:"WorkingDir"`
	Command         *[]string                                                             `name:"Command" type:"Repeated"`
}

// CreateJobTasksTaskSpecTaskExecutorItemVM is a repeated param struct in CreateJobRequest
type CreateJobTasksTaskSpecTaskExecutorItemVM struct {
	Image           string                                                         `name:"Image"`
	PrologScript    string                                                         `name:"PrologScript"`
	EnvironmentVars *[]CreateJobTasksTaskSpecTaskExecutorItemVMEnvironmentVarsItem `name:"EnvironmentVars" type:"Repeated"`
	Script          string                                                         `name:"Script"`
}

// CreateJobTasksTaskSpecTaskExecutorItemContainerEnvironmentVarsItem is a repeated param struct in CreateJobRequest
type CreateJobTasksTaskSpecTaskExecutorItemContainerEnvironmentVarsItem struct {
	Name  string `name:"Name"`
	Value string `name:"Value"`
}

// CreateJobTasksTaskSpecTaskExecutorItemVMEnvironmentVarsItem is a repeated param struct in CreateJobRequest
type CreateJobTasksTaskSpecTaskExecutorItemVMEnvironmentVarsItem struct {
	Name  string `name:"Name"`
	Value string `name:"Value"`
}

// CreateJobMonitorPolicy is a repeated param struct in CreateJobRequest
type CreateJobMonitorPolicy struct {
	NotificationSpec CreateJobMonitorPolicyNotificationSpec `name:"NotificationSpec" type:"Struct"`
}

// CreateJobDeploymentPolicy is a repeated param struct in CreateJobRequest
type CreateJobDeploymentPolicy struct {
	AllocationSpec string                           `name:"AllocationSpec"`
	Network        CreateJobDeploymentPolicyNetwork `name:"Network" type:"Struct"`
}

// CreateJobMonitorPolicyNotificationSpec is a repeated param struct in CreateJobRequest
type CreateJobMonitorPolicyNotificationSpec struct {
	MNSTopic *[]CreateJobMonitorPolicyNotificationSpecMNSTopicItem `name:"MNSTopic" type:"Repeated"`
}

// CreateJobDeploymentPolicyNetwork is a repeated param struct in CreateJobRequest
type CreateJobDeploymentPolicyNetwork struct {
	EnableERI        string    `name:"EnableERI"`
	Vswitch          *[]string `name:"Vswitch" type:"Repeated"`
	EnableENIMapping string    `name:"EnableENIMapping"`
}

// CreateJobMonitorPolicyNotificationSpecMNSTopicItem is a repeated param struct in CreateJobRequest
type CreateJobMonitorPolicyNotificationSpecMNSTopicItem struct {
	Event         *[]string `name:"Event" type:"Repeated"`
	TopicLocation string    `name:"TopicLocation"`
}

// CreateJobResponse is the response struct for api CreateJob
type CreateJobResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	JobId     string `json:"JobId" xml:"JobId"`
}

// CreateCreateJobRequest creates a request to invoke CreateJob API
func CreateCreateJobRequest() (request *CreateJobRequest) {
	request = &CreateJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("EhpcInstant", "2023-07-01", "CreateJob", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateJobResponse creates a response to parse from CreateJob response
func CreateCreateJobResponse() (response *CreateJobResponse) {
	response = &CreateJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
