package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListInstanceHistoryEvents invokes the elasticsearch.ListInstanceHistoryEvents API synchronously
func (client *Client) ListInstanceHistoryEvents(request *ListInstanceHistoryEventsRequest) (response *ListInstanceHistoryEventsResponse, err error) {
	response = CreateListInstanceHistoryEventsResponse()
	err = client.DoAction(request, response)
	return
}

// ListInstanceHistoryEventsWithChan invokes the elasticsearch.ListInstanceHistoryEvents API asynchronously
func (client *Client) ListInstanceHistoryEventsWithChan(request *ListInstanceHistoryEventsRequest) (<-chan *ListInstanceHistoryEventsResponse, <-chan error) {
	responseChan := make(chan *ListInstanceHistoryEventsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListInstanceHistoryEvents(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListInstanceHistoryEventsWithCallback invokes the elasticsearch.ListInstanceHistoryEvents API asynchronously
func (client *Client) ListInstanceHistoryEventsWithCallback(request *ListInstanceHistoryEventsRequest, callback func(response *ListInstanceHistoryEventsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListInstanceHistoryEventsResponse
		var err error
		defer close(result)
		response, err = client.ListInstanceHistoryEvents(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListInstanceHistoryEventsRequest is the request struct for api ListInstanceHistoryEvents
type ListInstanceHistoryEventsRequest struct {
	*requests.RoaRequest
	EventFinashEndTime    string           `position:"Query" name:"eventFinashEndTime"`
	InstanceId            string           `position:"Query" name:"instanceId"`
	Size                  requests.Integer `position:"Query" name:"size"`
	EventExecuteStartTime string           `position:"Query" name:"eventExecuteStartTime"`
	EventFinashStartTime  string           `position:"Query" name:"eventFinashStartTime"`
	NodeIP                string           `position:"Query" name:"nodeIP"`
	Page                  requests.Integer `position:"Query" name:"page"`
	EventCreateEndTime    string           `position:"Query" name:"eventCreateEndTime"`
	Body                  string           `position:"Body" name:"body"`
	EventCreateStartTime  string           `position:"Query" name:"eventCreateStartTime"`
	EventExecuteEndTime   string           `position:"Query" name:"eventExecuteEndTime"`
}

// ListInstanceHistoryEventsResponse is the response struct for api ListInstanceHistoryEvents
type ListInstanceHistoryEventsResponse struct {
	*responses.BaseResponse
	RequestId string       `json:"RequestId" xml:"RequestId"`
	Headers   Headers      `json:"Headers" xml:"Headers"`
	Result    []ResultItem `json:"Result" xml:"Result"`
}

// CreateListInstanceHistoryEventsRequest creates a request to invoke ListInstanceHistoryEvents API
func CreateListInstanceHistoryEventsRequest() (request *ListInstanceHistoryEventsRequest) {
	request = &ListInstanceHistoryEventsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "ListInstanceHistoryEvents", "/openapi/events", "elasticsearch", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListInstanceHistoryEventsResponse creates a response to parse from ListInstanceHistoryEvents response
func CreateListInstanceHistoryEventsResponse() (response *ListInstanceHistoryEventsResponse) {
	response = &ListInstanceHistoryEventsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
