package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ShrinkNode invokes the elasticsearch.ShrinkNode API synchronously
func (client *Client) ShrinkNode(request *ShrinkNodeRequest) (response *ShrinkNodeResponse, err error) {
	response = CreateShrinkNodeResponse()
	err = client.DoAction(request, response)
	return
}

// ShrinkNodeWithChan invokes the elasticsearch.ShrinkNode API asynchronously
func (client *Client) ShrinkNodeWithChan(request *ShrinkNodeRequest) (<-chan *ShrinkNodeResponse, <-chan error) {
	responseChan := make(chan *ShrinkNodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ShrinkNode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ShrinkNodeWithCallback invokes the elasticsearch.ShrinkNode API asynchronously
func (client *Client) ShrinkNodeWithCallback(request *ShrinkNodeRequest, callback func(response *ShrinkNodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ShrinkNodeResponse
		var err error
		defer close(result)
		response, err = client.ShrinkNode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ShrinkNodeRequest is the request struct for api ShrinkNode
type ShrinkNodeRequest struct {
	*requests.RoaRequest
	IgnoreStatus requests.Boolean `position:"Query" name:"ignoreStatus"`
	InstanceId   string           `position:"Path" name:"InstanceId"`
	NodeType     string           `position:"Query" name:"nodeType"`
	ClientToken  string           `position:"Query" name:"clientToken"`
	Count        requests.Integer `position:"Query" name:"count"`
	Body         string           `position:"Body" name:"body"`
}

// ShrinkNodeResponse is the response struct for api ShrinkNode
type ShrinkNodeResponse struct {
	*responses.BaseResponse
	Result    bool   `json:"Result" xml:"Result"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateShrinkNodeRequest creates a request to invoke ShrinkNode API
func CreateShrinkNodeRequest() (request *ShrinkNodeRequest) {
	request = &ShrinkNodeRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "ShrinkNode", "/openapi/instances/[InstanceId]/actions/shrink", "elasticsearch", "openAPI")
	request.Method = requests.POST
	return
}

// CreateShrinkNodeResponse creates a response to parse from ShrinkNode response
func CreateShrinkNodeResponse() (response *ShrinkNodeResponse) {
	response = &ShrinkNodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
