package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdatePipelineManagementConfig invokes the elasticsearch.UpdatePipelineManagementConfig API synchronously
func (client *Client) UpdatePipelineManagementConfig(request *UpdatePipelineManagementConfigRequest) (response *UpdatePipelineManagementConfigResponse, err error) {
	response = CreateUpdatePipelineManagementConfigResponse()
	err = client.DoAction(request, response)
	return
}

// UpdatePipelineManagementConfigWithChan invokes the elasticsearch.UpdatePipelineManagementConfig API asynchronously
func (client *Client) UpdatePipelineManagementConfigWithChan(request *UpdatePipelineManagementConfigRequest) (<-chan *UpdatePipelineManagementConfigResponse, <-chan error) {
	responseChan := make(chan *UpdatePipelineManagementConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdatePipelineManagementConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdatePipelineManagementConfigWithCallback invokes the elasticsearch.UpdatePipelineManagementConfig API asynchronously
func (client *Client) UpdatePipelineManagementConfigWithCallback(request *UpdatePipelineManagementConfigRequest, callback func(response *UpdatePipelineManagementConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdatePipelineManagementConfigResponse
		var err error
		defer close(result)
		response, err = client.UpdatePipelineManagementConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdatePipelineManagementConfigRequest is the request struct for api UpdatePipelineManagementConfig
type UpdatePipelineManagementConfigRequest struct {
	*requests.RoaRequest
	InstanceId  string `position:"Path" name:"InstanceId"`
	ClientToken string `position:"Query" name:"clientToken"`
	Body        string `position:"Body" name:"body"`
}

// UpdatePipelineManagementConfigResponse is the response struct for api UpdatePipelineManagementConfig
type UpdatePipelineManagementConfigResponse struct {
	*responses.BaseResponse
	Result    bool   `json:"Result" xml:"Result"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdatePipelineManagementConfigRequest creates a request to invoke UpdatePipelineManagementConfig API
func CreateUpdatePipelineManagementConfigRequest() (request *UpdatePipelineManagementConfigRequest) {
	request = &UpdatePipelineManagementConfigRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "UpdatePipelineManagementConfig", "/openapi/logstashes/[InstanceId]/pipeline-management-config", "elasticsearch", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdatePipelineManagementConfigResponse creates a response to parse from UpdatePipelineManagementConfig response
func CreateUpdatePipelineManagementConfigResponse() (response *UpdatePipelineManagementConfigResponse) {
	response = &UpdatePipelineManagementConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
