package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateNetwork invokes the ens.CreateNetwork API synchronously
func (client *Client) CreateNetwork(request *CreateNetworkRequest) (response *CreateNetworkResponse, err error) {
	response = CreateCreateNetworkResponse()
	err = client.DoAction(request, response)
	return
}

// CreateNetworkWithChan invokes the ens.CreateNetwork API asynchronously
func (client *Client) CreateNetworkWithChan(request *CreateNetworkRequest) (<-chan *CreateNetworkResponse, <-chan error) {
	responseChan := make(chan *CreateNetworkResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateNetwork(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateNetworkWithCallback invokes the ens.CreateNetwork API asynchronously
func (client *Client) CreateNetworkWithCallback(request *CreateNetworkRequest, callback func(response *CreateNetworkResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateNetworkResponse
		var err error
		defer close(result)
		response, err = client.CreateNetwork(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateNetworkRequest is the request struct for api CreateNetwork
type CreateNetworkRequest struct {
	*requests.RpcRequest
	Description string              `position:"Query" name:"Description"`
	EnsRegionId string              `position:"Query" name:"EnsRegionId"`
	NetworkName string              `position:"Query" name:"NetworkName"`
	Tag         *[]CreateNetworkTag `position:"Query" name:"Tag"  type:"Repeated"`
	CidrBlock   string              `position:"Query" name:"CidrBlock"`
}

// CreateNetworkTag is a repeated param struct in CreateNetworkRequest
type CreateNetworkTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// CreateNetworkResponse is the response struct for api CreateNetwork
type CreateNetworkResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	NetworkId string `json:"NetworkId" xml:"NetworkId"`
}

// CreateCreateNetworkRequest creates a request to invoke CreateNetwork API
func CreateCreateNetworkRequest() (request *CreateNetworkRequest) {
	request = &CreateNetworkRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "CreateNetwork", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateNetworkResponse creates a response to parse from CreateNetwork response
func CreateCreateNetworkResponse() (response *CreateNetworkResponse) {
	response = &CreateNetworkResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
