package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateNetworkInterface invokes the ens.CreateNetworkInterface API synchronously
func (client *Client) CreateNetworkInterface(request *CreateNetworkInterfaceRequest) (response *CreateNetworkInterfaceResponse, err error) {
	response = CreateCreateNetworkInterfaceResponse()
	err = client.DoAction(request, response)
	return
}

// CreateNetworkInterfaceWithChan invokes the ens.CreateNetworkInterface API asynchronously
func (client *Client) CreateNetworkInterfaceWithChan(request *CreateNetworkInterfaceRequest) (<-chan *CreateNetworkInterfaceResponse, <-chan error) {
	responseChan := make(chan *CreateNetworkInterfaceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateNetworkInterface(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateNetworkInterfaceWithCallback invokes the ens.CreateNetworkInterface API asynchronously
func (client *Client) CreateNetworkInterfaceWithCallback(request *CreateNetworkInterfaceRequest, callback func(response *CreateNetworkInterfaceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateNetworkInterfaceResponse
		var err error
		defer close(result)
		response, err = client.CreateNetworkInterface(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateNetworkInterfaceRequest is the request struct for api CreateNetworkInterface
type CreateNetworkInterfaceRequest struct {
	*requests.RpcRequest
	Description      string    `position:"Query" name:"Description"`
	SecurityGroupIds *[]string `position:"Query" name:"SecurityGroupIds"  type:"Json"`
	VSwitchId        string    `position:"Query" name:"VSwitchId"`
	Name             string    `position:"Query" name:"Name"`
}

// CreateNetworkInterfaceResponse is the response struct for api CreateNetworkInterface
type CreateNetworkInterfaceResponse struct {
	*responses.BaseResponse
	RequestId           string   `json:"RequestId" xml:"RequestId"`
	NetworkInterfaceIds []string `json:"NetworkInterfaceIds" xml:"NetworkInterfaceIds"`
}

// CreateCreateNetworkInterfaceRequest creates a request to invoke CreateNetworkInterface API
func CreateCreateNetworkInterfaceRequest() (request *CreateNetworkInterfaceRequest) {
	request = &CreateNetworkInterfaceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "CreateNetworkInterface", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateNetworkInterfaceResponse creates a response to parse from CreateNetworkInterface response
func CreateCreateNetworkInterfaceResponse() (response *CreateNetworkInterfaceResponse) {
	response = &CreateNetworkInterfaceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
