package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveInstanceSDG invokes the ens.RemoveInstanceSDG API synchronously
func (client *Client) RemoveInstanceSDG(request *RemoveInstanceSDGRequest) (response *RemoveInstanceSDGResponse, err error) {
	response = CreateRemoveInstanceSDGResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveInstanceSDGWithChan invokes the ens.RemoveInstanceSDG API asynchronously
func (client *Client) RemoveInstanceSDGWithChan(request *RemoveInstanceSDGRequest) (<-chan *RemoveInstanceSDGResponse, <-chan error) {
	responseChan := make(chan *RemoveInstanceSDGResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveInstanceSDG(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveInstanceSDGWithCallback invokes the ens.RemoveInstanceSDG API asynchronously
func (client *Client) RemoveInstanceSDGWithCallback(request *RemoveInstanceSDGRequest, callback func(response *RemoveInstanceSDGResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveInstanceSDGResponse
		var err error
		defer close(result)
		response, err = client.RemoveInstanceSDG(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveInstanceSDGRequest is the request struct for api RemoveInstanceSDG
type RemoveInstanceSDGRequest struct {
	*requests.RpcRequest
	InstanceIds *[]string `position:"Query" name:"InstanceIds"  type:"Json"`
}

// RemoveInstanceSDGResponse is the response struct for api RemoveInstanceSDG
type RemoveInstanceSDGResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateRemoveInstanceSDGRequest creates a request to invoke RemoveInstanceSDG API
func CreateRemoveInstanceSDGRequest() (request *RemoveInstanceSDGRequest) {
	request = &RemoveInstanceSDGRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "RemoveInstanceSDG", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRemoveInstanceSDGResponse creates a response to parse from RemoveInstanceSDG response
func CreateRemoveInstanceSDGResponse() (response *RemoveInstanceSDGResponse) {
	response = &RemoveInstanceSDGResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
