package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UnmountInstanceSDG invokes the ens.UnmountInstanceSDG API synchronously
func (client *Client) UnmountInstanceSDG(request *UnmountInstanceSDGRequest) (response *UnmountInstanceSDGResponse, err error) {
	response = CreateUnmountInstanceSDGResponse()
	err = client.DoAction(request, response)
	return
}

// UnmountInstanceSDGWithChan invokes the ens.UnmountInstanceSDG API asynchronously
func (client *Client) UnmountInstanceSDGWithChan(request *UnmountInstanceSDGRequest) (<-chan *UnmountInstanceSDGResponse, <-chan error) {
	responseChan := make(chan *UnmountInstanceSDGResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UnmountInstanceSDG(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UnmountInstanceSDGWithCallback invokes the ens.UnmountInstanceSDG API asynchronously
func (client *Client) UnmountInstanceSDGWithCallback(request *UnmountInstanceSDGRequest, callback func(response *UnmountInstanceSDGResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UnmountInstanceSDGResponse
		var err error
		defer close(result)
		response, err = client.UnmountInstanceSDG(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UnmountInstanceSDGRequest is the request struct for api UnmountInstanceSDG
type UnmountInstanceSDGRequest struct {
	*requests.RpcRequest
	SDGId       string    `position:"Query" name:"SDGId"`
	InstanceIds *[]string `position:"Query" name:"InstanceIds"  type:"Json"`
}

// UnmountInstanceSDGResponse is the response struct for api UnmountInstanceSDG
type UnmountInstanceSDGResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateUnmountInstanceSDGRequest creates a request to invoke UnmountInstanceSDG API
func CreateUnmountInstanceSDGRequest() (request *UnmountInstanceSDGRequest) {
	request = &UnmountInstanceSDGRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "UnmountInstanceSDG", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUnmountInstanceSDGResponse creates a response to parse from UnmountInstanceSDG response
func CreateUnmountInstanceSDGResponse() (response *UnmountInstanceSDGResponse) {
	response = &UnmountInstanceSDGResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
