package ess

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DetachServerGroups invokes the ess.DetachServerGroups API synchronously
func (client *Client) DetachServerGroups(request *DetachServerGroupsRequest) (response *DetachServerGroupsResponse, err error) {
	response = CreateDetachServerGroupsResponse()
	err = client.DoAction(request, response)
	return
}

// DetachServerGroupsWithChan invokes the ess.DetachServerGroups API asynchronously
func (client *Client) DetachServerGroupsWithChan(request *DetachServerGroupsRequest) (<-chan *DetachServerGroupsResponse, <-chan error) {
	responseChan := make(chan *DetachServerGroupsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DetachServerGroups(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DetachServerGroupsWithCallback invokes the ess.DetachServerGroups API asynchronously
func (client *Client) DetachServerGroupsWithCallback(request *DetachServerGroupsRequest, callback func(response *DetachServerGroupsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DetachServerGroupsResponse
		var err error
		defer close(result)
		response, err = client.DetachServerGroups(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DetachServerGroupsRequest is the request struct for api DetachServerGroups
type DetachServerGroupsRequest struct {
	*requests.RpcRequest
	ClientToken          string                           `position:"Query" name:"ClientToken"`
	ScalingGroupId       string                           `position:"Query" name:"ScalingGroupId"`
	ServerGroup          *[]DetachServerGroupsServerGroup `position:"Query" name:"ServerGroup"  type:"Repeated"`
	ResourceOwnerAccount string                           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer                 `position:"Query" name:"OwnerId"`
	ForceDetach          requests.Boolean                 `position:"Query" name:"ForceDetach"`
}

// DetachServerGroupsServerGroup is a repeated param struct in DetachServerGroupsRequest
type DetachServerGroupsServerGroup struct {
	ServerGroupId string `name:"ServerGroupId"`
	Port          string `name:"Port"`
	Type          string `name:"Type"`
}

// DetachServerGroupsResponse is the response struct for api DetachServerGroups
type DetachServerGroupsResponse struct {
	*responses.BaseResponse
	ScalingActivityId string `json:"ScalingActivityId" xml:"ScalingActivityId"`
	RequestId         string `json:"RequestId" xml:"RequestId"`
}

// CreateDetachServerGroupsRequest creates a request to invoke DetachServerGroups API
func CreateDetachServerGroupsRequest() (request *DetachServerGroupsRequest) {
	request = &DetachServerGroupsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ess", "2014-08-28", "DetachServerGroups", "ess", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDetachServerGroupsResponse creates a response to parse from DetachServerGroups response
func CreateDetachServerGroupsResponse() (response *DetachServerGroupsResponse) {
	response = &DetachServerGroupsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
