package eventbridge

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateApiDestination invokes the eventbridge.CreateApiDestination API synchronously
func (client *Client) CreateApiDestination(request *CreateApiDestinationRequest) (response *CreateApiDestinationResponse, err error) {
	response = CreateCreateApiDestinationResponse()
	err = client.DoAction(request, response)
	return
}

// CreateApiDestinationWithChan invokes the eventbridge.CreateApiDestination API asynchronously
func (client *Client) CreateApiDestinationWithChan(request *CreateApiDestinationRequest) (<-chan *CreateApiDestinationResponse, <-chan error) {
	responseChan := make(chan *CreateApiDestinationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateApiDestination(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateApiDestinationWithCallback invokes the eventbridge.CreateApiDestination API asynchronously
func (client *Client) CreateApiDestinationWithCallback(request *CreateApiDestinationRequest, callback func(response *CreateApiDestinationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateApiDestinationResponse
		var err error
		defer close(result)
		response, err = client.CreateApiDestination(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateApiDestinationRequest is the request struct for api CreateApiDestination
type CreateApiDestinationRequest struct {
	*requests.RpcRequest
	ConnectionName               string                                `position:"Query" name:"ConnectionName"`
	Description                  string                                `position:"Query" name:"Description"`
	HttpApiParameters            CreateApiDestinationHttpApiParameters `position:"Query" name:"HttpApiParameters"  type:"Struct"`
	ApiDestinationName           string                                `position:"Query" name:"ApiDestinationName"`
	InvocationRateLimitPerSecond requests.Integer                      `position:"Query" name:"InvocationRateLimitPerSecond"`
}

// CreateApiDestinationHttpApiParameters is a repeated param struct in CreateApiDestinationRequest
type CreateApiDestinationHttpApiParameters struct {
	Endpoint      string                                                    `name:"Endpoint"`
	Method        string                                                    `name:"Method"`
	ApiParameters *[]CreateApiDestinationHttpApiParametersApiParametersItem `name:"ApiParameters" type:"Repeated"`
}

// CreateApiDestinationHttpApiParametersApiParametersItem is a repeated param struct in CreateApiDestinationRequest
type CreateApiDestinationHttpApiParametersApiParametersItem struct {
	In           string `name:"In"`
	Name         string `name:"Name"`
	Description  string `name:"Description"`
	DefaultValue string `name:"DefaultValue"`
	Type         string `name:"Type"`
}

// CreateApiDestinationResponse is the response struct for api CreateApiDestination
type CreateApiDestinationResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Code      string `json:"Code" xml:"Code"`
	Date      Date   `json:"Date" xml:"Date"`
}

// CreateCreateApiDestinationRequest creates a request to invoke CreateApiDestination API
func CreateCreateApiDestinationRequest() (request *CreateApiDestinationRequest) {
	request = &CreateApiDestinationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eventbridge", "2020-04-01", "CreateApiDestination", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateApiDestinationResponse creates a response to parse from CreateApiDestination response
func CreateCreateApiDestinationResponse() (response *CreateApiDestinationResponse) {
	response = &CreateApiDestinationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
