package eventbridge

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateEventSource invokes the eventbridge.UpdateEventSource API synchronously
func (client *Client) UpdateEventSource(request *UpdateEventSourceRequest) (response *UpdateEventSourceResponse, err error) {
	response = CreateUpdateEventSourceResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateEventSourceWithChan invokes the eventbridge.UpdateEventSource API asynchronously
func (client *Client) UpdateEventSourceWithChan(request *UpdateEventSourceRequest) (<-chan *UpdateEventSourceResponse, <-chan error) {
	responseChan := make(chan *UpdateEventSourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateEventSource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateEventSourceWithCallback invokes the eventbridge.UpdateEventSource API asynchronously
func (client *Client) UpdateEventSourceWithCallback(request *UpdateEventSourceRequest, callback func(response *UpdateEventSourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateEventSourceResponse
		var err error
		defer close(result)
		response, err = client.UpdateEventSource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateEventSourceRequest is the request struct for api UpdateEventSource
type UpdateEventSourceRequest struct {
	*requests.RpcRequest
	Description                    string                                          `position:"Body" name:"Description"`
	EventBusName                   string                                          `position:"Body" name:"EventBusName"`
	SourceMNSParameters            UpdateEventSourceSourceMNSParameters            `position:"Body" name:"SourceMNSParameters"  type:"Struct"`
	LinkedExternalSource           requests.Boolean                                `position:"Body" name:"LinkedExternalSource"`
	ExternalSourceType             string                                          `position:"Body" name:"ExternalSourceType"`
	ExternalSourceConfig           map[string]string                               `position:"Body" name:"ExternalSourceConfig"  type:"Map"`
	SourceRabbitMQParameters       UpdateEventSourceSourceRabbitMQParameters       `position:"Body" name:"SourceRabbitMQParameters"  type:"Struct"`
	SourceRocketMQParameters       UpdateEventSourceSourceRocketMQParameters       `position:"Body" name:"SourceRocketMQParameters"  type:"Struct"`
	SourceSLSParameters            UpdateEventSourceSourceSLSParameters            `position:"Body" name:"SourceSLSParameters"  type:"Struct"`
	SourceScheduledEventParameters UpdateEventSourceSourceScheduledEventParameters `position:"Body" name:"SourceScheduledEventParameters"  type:"Struct"`
	SourceKafkaParameters          UpdateEventSourceSourceKafkaParameters          `position:"Body" name:"SourceKafkaParameters"  type:"Struct"`
	SourceHttpEventParameters      UpdateEventSourceSourceHttpEventParameters      `position:"Body" name:"SourceHttpEventParameters"  type:"Struct"`
	EventSourceName                string                                          `position:"Body" name:"EventSourceName"`
}

// UpdateEventSourceSourceMNSParameters is a repeated param struct in UpdateEventSourceRequest
type UpdateEventSourceSourceMNSParameters struct {
	QueueName      string `name:"QueueName"`
	RegionId       string `name:"RegionId"`
	IsBase64Decode string `name:"IsBase64Decode"`
}

// UpdateEventSourceSourceRabbitMQParameters is a repeated param struct in UpdateEventSourceRequest
type UpdateEventSourceSourceRabbitMQParameters struct {
	QueueName       string `name:"QueueName"`
	VirtualHostName string `name:"VirtualHostName"`
	InstanceId      string `name:"InstanceId"`
	RegionId        string `name:"RegionId"`
}

// UpdateEventSourceSourceRocketMQParameters is a repeated param struct in UpdateEventSourceRequest
type UpdateEventSourceSourceRocketMQParameters struct {
	InstanceSecurityGroupId string `name:"InstanceSecurityGroupId"`
	Offset                  string `name:"Offset"`
	GroupID                 string `name:"GroupID"`
	InstanceUsername        string `name:"InstanceUsername"`
	AuthType                string `name:"AuthType"`
	InstancePassword        string `name:"InstancePassword"`
	InstanceNetwork         string `name:"InstanceNetwork"`
	InstanceVSwitchIds      string `name:"InstanceVSwitchIds"`
	InstanceId              string `name:"InstanceId"`
	InstanceVpcId           string `name:"InstanceVpcId"`
	InstanceEndpoint        string `name:"InstanceEndpoint"`
	RegionId                string `name:"RegionId"`
	Topic                   string `name:"Topic"`
	InstanceType            string `name:"InstanceType"`
	Tag                     string `name:"Tag"`
	Timestamp               string `name:"Timestamp"`
}

// UpdateEventSourceSourceSLSParameters is a repeated param struct in UpdateEventSourceRequest
type UpdateEventSourceSourceSLSParameters struct {
	RoleName        string `name:"RoleName"`
	Project         string `name:"Project"`
	LogStore        string `name:"LogStore"`
	ConsumePosition string `name:"ConsumePosition"`
}

// UpdateEventSourceSourceScheduledEventParameters is a repeated param struct in UpdateEventSourceRequest
type UpdateEventSourceSourceScheduledEventParameters struct {
	Schedule string `name:"Schedule"`
	UserData string `name:"UserData"`
	TimeZone string `name:"TimeZone"`
}

// UpdateEventSourceSourceKafkaParameters is a repeated param struct in UpdateEventSourceRequest
type UpdateEventSourceSourceKafkaParameters struct {
	InstanceId      string `name:"InstanceId"`
	ConsumerGroup   string `name:"ConsumerGroup"`
	RegionId        string `name:"RegionId"`
	VSwitchIds      string `name:"VSwitchIds"`
	VpcId           string `name:"VpcId"`
	SecurityGroupId string `name:"SecurityGroupId"`
	Topic           string `name:"Topic"`
	OffsetReset     string `name:"OffsetReset"`
	MaximumTasks    string `name:"MaximumTasks"`
	Network         string `name:"Network"`
}

// UpdateEventSourceSourceHttpEventParameters is a repeated param struct in UpdateEventSourceRequest
type UpdateEventSourceSourceHttpEventParameters struct {
	Referer        *[]string `name:"Referer" type:"Repeated"`
	Method         *[]string `name:"Method" type:"Repeated"`
	Ip             *[]string `name:"Ip" type:"Repeated"`
	SecurityConfig string    `name:"SecurityConfig"`
	Type           string    `name:"Type"`
}

// UpdateEventSourceResponse is the response struct for api UpdateEventSource
type UpdateEventSourceResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      bool   `json:"Data" xml:"Data"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateUpdateEventSourceRequest creates a request to invoke UpdateEventSource API
func CreateUpdateEventSourceRequest() (request *UpdateEventSourceRequest) {
	request = &UpdateEventSourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eventbridge", "2020-04-01", "UpdateEventSource", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateEventSourceResponse creates a response to parse from UpdateEventSource response
func CreateUpdateEventSourceResponse() (response *UpdateEventSourceResponse) {
	response = &UpdateEventSourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
