package governance

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListEvaluationScoreHistory invokes the governance.ListEvaluationScoreHistory API synchronously
func (client *Client) ListEvaluationScoreHistory(request *ListEvaluationScoreHistoryRequest) (response *ListEvaluationScoreHistoryResponse, err error) {
	response = CreateListEvaluationScoreHistoryResponse()
	err = client.DoAction(request, response)
	return
}

// ListEvaluationScoreHistoryWithChan invokes the governance.ListEvaluationScoreHistory API asynchronously
func (client *Client) ListEvaluationScoreHistoryWithChan(request *ListEvaluationScoreHistoryRequest) (<-chan *ListEvaluationScoreHistoryResponse, <-chan error) {
	responseChan := make(chan *ListEvaluationScoreHistoryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListEvaluationScoreHistory(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListEvaluationScoreHistoryWithCallback invokes the governance.ListEvaluationScoreHistory API asynchronously
func (client *Client) ListEvaluationScoreHistoryWithCallback(request *ListEvaluationScoreHistoryRequest, callback func(response *ListEvaluationScoreHistoryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListEvaluationScoreHistoryResponse
		var err error
		defer close(result)
		response, err = client.ListEvaluationScoreHistory(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListEvaluationScoreHistoryRequest is the request struct for api ListEvaluationScoreHistory
type ListEvaluationScoreHistoryRequest struct {
	*requests.RpcRequest
	StartDate     string           `position:"Query" name:"StartDate"`
	PartnerCode   string           `position:"Query" name:"PartnerCode"`
	EndDate       string           `position:"Query" name:"EndDate"`
	ShowScoreDiff requests.Boolean `position:"Query" name:"ShowScoreDiff"`
}

// ListEvaluationScoreHistoryResponse is the response struct for api ListEvaluationScoreHistory
type ListEvaluationScoreHistoryResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	ScoreDiff    ScoreDiff    `json:"ScoreDiff" xml:"ScoreDiff"`
	ScoreHistory ScoreHistory `json:"ScoreHistory" xml:"ScoreHistory"`
}

// CreateListEvaluationScoreHistoryRequest creates a request to invoke ListEvaluationScoreHistory API
func CreateListEvaluationScoreHistoryRequest() (request *ListEvaluationScoreHistoryRequest) {
	request = &ListEvaluationScoreHistoryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("governance", "2021-01-20", "ListEvaluationScoreHistory", "governance", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListEvaluationScoreHistoryResponse creates a response to parse from ListEvaluationScoreHistory response
func CreateListEvaluationScoreHistoryResponse() (response *ListEvaluationScoreHistoryResponse) {
	response = &ListEvaluationScoreHistoryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
