package gpdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDBInstanceResourceGroup invokes the gpdb.ModifyDBInstanceResourceGroup API synchronously
func (client *Client) ModifyDBInstanceResourceGroup(request *ModifyDBInstanceResourceGroupRequest) (response *ModifyDBInstanceResourceGroupResponse, err error) {
	response = CreateModifyDBInstanceResourceGroupResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDBInstanceResourceGroupWithChan invokes the gpdb.ModifyDBInstanceResourceGroup API asynchronously
func (client *Client) ModifyDBInstanceResourceGroupWithChan(request *ModifyDBInstanceResourceGroupRequest) (<-chan *ModifyDBInstanceResourceGroupResponse, <-chan error) {
	responseChan := make(chan *ModifyDBInstanceResourceGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDBInstanceResourceGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDBInstanceResourceGroupWithCallback invokes the gpdb.ModifyDBInstanceResourceGroup API asynchronously
func (client *Client) ModifyDBInstanceResourceGroupWithCallback(request *ModifyDBInstanceResourceGroupRequest, callback func(response *ModifyDBInstanceResourceGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDBInstanceResourceGroupResponse
		var err error
		defer close(result)
		response, err = client.ModifyDBInstanceResourceGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDBInstanceResourceGroupRequest is the request struct for api ModifyDBInstanceResourceGroup
type ModifyDBInstanceResourceGroupRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceGroupId      string           `position:"Query" name:"ResourceGroupId"`
	DBInstanceId         string           `position:"Query" name:"DBInstanceId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	NewResourceGroupId   string           `position:"Query" name:"NewResourceGroupId"`
}

// ModifyDBInstanceResourceGroupResponse is the response struct for api ModifyDBInstanceResourceGroup
type ModifyDBInstanceResourceGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyDBInstanceResourceGroupRequest creates a request to invoke ModifyDBInstanceResourceGroup API
func CreateModifyDBInstanceResourceGroupRequest() (request *ModifyDBInstanceResourceGroupRequest) {
	request = &ModifyDBInstanceResourceGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("gpdb", "2016-05-03", "ModifyDBInstanceResourceGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyDBInstanceResourceGroupResponse creates a response to parse from ModifyDBInstanceResourceGroup response
func CreateModifyDBInstanceResourceGroupResponse() (response *ModifyDBInstanceResourceGroupResponse) {
	response = &ModifyDBInstanceResourceGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
