package gpdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetDataShareInstance invokes the gpdb.SetDataShareInstance API synchronously
func (client *Client) SetDataShareInstance(request *SetDataShareInstanceRequest) (response *SetDataShareInstanceResponse, err error) {
	response = CreateSetDataShareInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// SetDataShareInstanceWithChan invokes the gpdb.SetDataShareInstance API asynchronously
func (client *Client) SetDataShareInstanceWithChan(request *SetDataShareInstanceRequest) (<-chan *SetDataShareInstanceResponse, <-chan error) {
	responseChan := make(chan *SetDataShareInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetDataShareInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetDataShareInstanceWithCallback invokes the gpdb.SetDataShareInstance API asynchronously
func (client *Client) SetDataShareInstanceWithCallback(request *SetDataShareInstanceRequest, callback func(response *SetDataShareInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetDataShareInstanceResponse
		var err error
		defer close(result)
		response, err = client.SetDataShareInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetDataShareInstanceRequest is the request struct for api SetDataShareInstance
type SetDataShareInstanceRequest struct {
	*requests.RpcRequest
	InstanceList  *[]string        `position:"Query" name:"InstanceList"  type:"Json"`
	OperationType string           `position:"Query" name:"OperationType"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
}

// SetDataShareInstanceResponse is the response struct for api SetDataShareInstance
type SetDataShareInstanceResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Status     string `json:"Status" xml:"Status"`
	ErrMessage string `json:"ErrMessage" xml:"ErrMessage"`
}

// CreateSetDataShareInstanceRequest creates a request to invoke SetDataShareInstance API
func CreateSetDataShareInstanceRequest() (request *SetDataShareInstanceRequest) {
	request = &SetDataShareInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("gpdb", "2016-05-03", "SetDataShareInstance", "", "")
	request.Method = requests.POST
	return
}

// CreateSetDataShareInstanceResponse creates a response to parse from SetDataShareInstance response
func CreateSetDataShareInstanceResponse() (response *SetDataShareInstanceResponse) {
	response = &SetDataShareInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
