package ims

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddClientIdToOIDCProvider invokes the ims.AddClientIdToOIDCProvider API synchronously
func (client *Client) AddClientIdToOIDCProvider(request *AddClientIdToOIDCProviderRequest) (response *AddClientIdToOIDCProviderResponse, err error) {
	response = CreateAddClientIdToOIDCProviderResponse()
	err = client.DoAction(request, response)
	return
}

// AddClientIdToOIDCProviderWithChan invokes the ims.AddClientIdToOIDCProvider API asynchronously
func (client *Client) AddClientIdToOIDCProviderWithChan(request *AddClientIdToOIDCProviderRequest) (<-chan *AddClientIdToOIDCProviderResponse, <-chan error) {
	responseChan := make(chan *AddClientIdToOIDCProviderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddClientIdToOIDCProvider(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddClientIdToOIDCProviderWithCallback invokes the ims.AddClientIdToOIDCProvider API asynchronously
func (client *Client) AddClientIdToOIDCProviderWithCallback(request *AddClientIdToOIDCProviderRequest, callback func(response *AddClientIdToOIDCProviderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddClientIdToOIDCProviderResponse
		var err error
		defer close(result)
		response, err = client.AddClientIdToOIDCProvider(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddClientIdToOIDCProviderRequest is the request struct for api AddClientIdToOIDCProvider
type AddClientIdToOIDCProviderRequest struct {
	*requests.RpcRequest
	ClientId         string `position:"Query" name:"ClientId"`
	AkProxySuffix    string `position:"Query" name:"AkProxySuffix"`
	OIDCProviderName string `position:"Query" name:"OIDCProviderName"`
}

// AddClientIdToOIDCProviderResponse is the response struct for api AddClientIdToOIDCProvider
type AddClientIdToOIDCProviderResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	OIDCProvider OIDCProvider `json:"OIDCProvider" xml:"OIDCProvider"`
}

// CreateAddClientIdToOIDCProviderRequest creates a request to invoke AddClientIdToOIDCProvider API
func CreateAddClientIdToOIDCProviderRequest() (request *AddClientIdToOIDCProviderRequest) {
	request = &AddClientIdToOIDCProviderRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ims", "2019-08-15", "AddClientIdToOIDCProvider", "ims", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddClientIdToOIDCProviderResponse creates a response to parse from AddClientIdToOIDCProvider response
func CreateAddClientIdToOIDCProviderResponse() (response *AddClientIdToOIDCProviderResponse) {
	response = &AddClientIdToOIDCProviderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
