package ims

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateAppSecret invokes the ims.CreateAppSecret API synchronously
func (client *Client) CreateAppSecret(request *CreateAppSecretRequest) (response *CreateAppSecretResponse, err error) {
	response = CreateCreateAppSecretResponse()
	err = client.DoAction(request, response)
	return
}

// CreateAppSecretWithChan invokes the ims.CreateAppSecret API asynchronously
func (client *Client) CreateAppSecretWithChan(request *CreateAppSecretRequest) (<-chan *CreateAppSecretResponse, <-chan error) {
	responseChan := make(chan *CreateAppSecretResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateAppSecret(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateAppSecretWithCallback invokes the ims.CreateAppSecret API asynchronously
func (client *Client) CreateAppSecretWithCallback(request *CreateAppSecretRequest, callback func(response *CreateAppSecretResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateAppSecretResponse
		var err error
		defer close(result)
		response, err = client.CreateAppSecret(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateAppSecretRequest is the request struct for api CreateAppSecret
type CreateAppSecretRequest struct {
	*requests.RpcRequest
	AkProxySuffix string `position:"Query" name:"AkProxySuffix"`
	AppId         string `position:"Query" name:"AppId"`
}

// CreateAppSecretResponse is the response struct for api CreateAppSecret
type CreateAppSecretResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	AppSecret AppSecret `json:"AppSecret" xml:"AppSecret"`
}

// CreateCreateAppSecretRequest creates a request to invoke CreateAppSecret API
func CreateCreateAppSecretRequest() (request *CreateAppSecretRequest) {
	request = &CreateAppSecretRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ims", "2019-08-15", "CreateAppSecret", "ims", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateAppSecretResponse creates a response to parse from CreateAppSecret response
func CreateCreateAppSecretResponse() (response *CreateAppSecretResponse) {
	response = &CreateAppSecretResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
