package ims

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetOIDCProvider invokes the ims.GetOIDCProvider API synchronously
func (client *Client) GetOIDCProvider(request *GetOIDCProviderRequest) (response *GetOIDCProviderResponse, err error) {
	response = CreateGetOIDCProviderResponse()
	err = client.DoAction(request, response)
	return
}

// GetOIDCProviderWithChan invokes the ims.GetOIDCProvider API asynchronously
func (client *Client) GetOIDCProviderWithChan(request *GetOIDCProviderRequest) (<-chan *GetOIDCProviderResponse, <-chan error) {
	responseChan := make(chan *GetOIDCProviderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetOIDCProvider(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetOIDCProviderWithCallback invokes the ims.GetOIDCProvider API asynchronously
func (client *Client) GetOIDCProviderWithCallback(request *GetOIDCProviderRequest, callback func(response *GetOIDCProviderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetOIDCProviderResponse
		var err error
		defer close(result)
		response, err = client.GetOIDCProvider(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetOIDCProviderRequest is the request struct for api GetOIDCProvider
type GetOIDCProviderRequest struct {
	*requests.RpcRequest
	AkProxySuffix    string `position:"Query" name:"AkProxySuffix"`
	OIDCProviderName string `position:"Query" name:"OIDCProviderName"`
}

// GetOIDCProviderResponse is the response struct for api GetOIDCProvider
type GetOIDCProviderResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	OIDCProvider OIDCProvider `json:"OIDCProvider" xml:"OIDCProvider"`
}

// CreateGetOIDCProviderRequest creates a request to invoke GetOIDCProvider API
func CreateGetOIDCProviderRequest() (request *GetOIDCProviderRequest) {
	request = &GetOIDCProviderRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ims", "2019-08-15", "GetOIDCProvider", "ims", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetOIDCProviderResponse creates a response to parse from GetOIDCProvider response
func CreateGetOIDCProviderResponse() (response *GetOIDCProviderResponse) {
	response = &GetOIDCProviderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
