package ims

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetVerificationInfo invokes the ims.GetVerificationInfo API synchronously
func (client *Client) GetVerificationInfo(request *GetVerificationInfoRequest) (response *GetVerificationInfoResponse, err error) {
	response = CreateGetVerificationInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetVerificationInfoWithChan invokes the ims.GetVerificationInfo API asynchronously
func (client *Client) GetVerificationInfoWithChan(request *GetVerificationInfoRequest) (<-chan *GetVerificationInfoResponse, <-chan error) {
	responseChan := make(chan *GetVerificationInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetVerificationInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetVerificationInfoWithCallback invokes the ims.GetVerificationInfo API asynchronously
func (client *Client) GetVerificationInfoWithCallback(request *GetVerificationInfoRequest, callback func(response *GetVerificationInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetVerificationInfoResponse
		var err error
		defer close(result)
		response, err = client.GetVerificationInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetVerificationInfoRequest is the request struct for api GetVerificationInfo
type GetVerificationInfoRequest struct {
	*requests.RpcRequest
	UserPrincipalName string `position:"Query" name:"UserPrincipalName"`
}

// GetVerificationInfoResponse is the response struct for api GetVerificationInfo
type GetVerificationInfoResponse struct {
	*responses.BaseResponse
	RequestId           string              `json:"RequestId" xml:"RequestId"`
	SecurityPhoneDevice SecurityPhoneDevice `json:"SecurityPhoneDevice" xml:"SecurityPhoneDevice"`
	SecurityEmailDevice SecurityEmailDevice `json:"SecurityEmailDevice" xml:"SecurityEmailDevice"`
}

// CreateGetVerificationInfoRequest creates a request to invoke GetVerificationInfo API
func CreateGetVerificationInfoRequest() (request *GetVerificationInfoRequest) {
	request = &GetVerificationInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ims", "2019-08-15", "GetVerificationInfo", "ims", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetVerificationInfoResponse creates a response to parse from GetVerificationInfo response
func CreateGetVerificationInfoResponse() (response *GetVerificationInfoResponse) {
	response = &GetVerificationInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
