package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteEdgeDriver invokes the iot.DeleteEdgeDriver API synchronously
func (client *Client) DeleteEdgeDriver(request *DeleteEdgeDriverRequest) (response *DeleteEdgeDriverResponse, err error) {
	response = CreateDeleteEdgeDriverResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteEdgeDriverWithChan invokes the iot.DeleteEdgeDriver API asynchronously
func (client *Client) DeleteEdgeDriverWithChan(request *DeleteEdgeDriverRequest) (<-chan *DeleteEdgeDriverResponse, <-chan error) {
	responseChan := make(chan *DeleteEdgeDriverResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteEdgeDriver(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteEdgeDriverWithCallback invokes the iot.DeleteEdgeDriver API asynchronously
func (client *Client) DeleteEdgeDriverWithCallback(request *DeleteEdgeDriverRequest, callback func(response *DeleteEdgeDriverResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteEdgeDriverResponse
		var err error
		defer close(result)
		response, err = client.DeleteEdgeDriver(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteEdgeDriverRequest is the request struct for api DeleteEdgeDriver
type DeleteEdgeDriverRequest struct {
	*requests.RpcRequest
	DriverId      string `position:"Query" name:"DriverId"`
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
}

// DeleteEdgeDriverResponse is the response struct for api DeleteEdgeDriver
type DeleteEdgeDriverResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateDeleteEdgeDriverRequest creates a request to invoke DeleteEdgeDriver API
func CreateDeleteEdgeDriverRequest() (request *DeleteEdgeDriverRequest) {
	request = &DeleteEdgeDriverRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "DeleteEdgeDriver", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteEdgeDriverResponse creates a response to parse from DeleteEdgeDriver response
func CreateDeleteEdgeDriverResponse() (response *DeleteEdgeDriverResponse) {
	response = &DeleteEdgeDriverResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
