package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetEdgeDriverVersion invokes the iot.GetEdgeDriverVersion API synchronously
func (client *Client) GetEdgeDriverVersion(request *GetEdgeDriverVersionRequest) (response *GetEdgeDriverVersionResponse, err error) {
	response = CreateGetEdgeDriverVersionResponse()
	err = client.DoAction(request, response)
	return
}

// GetEdgeDriverVersionWithChan invokes the iot.GetEdgeDriverVersion API asynchronously
func (client *Client) GetEdgeDriverVersionWithChan(request *GetEdgeDriverVersionRequest) (<-chan *GetEdgeDriverVersionResponse, <-chan error) {
	responseChan := make(chan *GetEdgeDriverVersionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetEdgeDriverVersion(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetEdgeDriverVersionWithCallback invokes the iot.GetEdgeDriverVersion API asynchronously
func (client *Client) GetEdgeDriverVersionWithCallback(request *GetEdgeDriverVersionRequest, callback func(response *GetEdgeDriverVersionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetEdgeDriverVersionResponse
		var err error
		defer close(result)
		response, err = client.GetEdgeDriverVersion(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetEdgeDriverVersionRequest is the request struct for api GetEdgeDriverVersion
type GetEdgeDriverVersionRequest struct {
	*requests.RpcRequest
	DriverId      string `position:"Query" name:"DriverId"`
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	DriverVersion string `position:"Query" name:"DriverVersion"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
}

// GetEdgeDriverVersionResponse is the response struct for api GetEdgeDriverVersion
type GetEdgeDriverVersionResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateGetEdgeDriverVersionRequest creates a request to invoke GetEdgeDriverVersion API
func CreateGetEdgeDriverVersionRequest() (request *GetEdgeDriverVersionRequest) {
	request = &GetEdgeDriverVersionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "GetEdgeDriverVersion", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetEdgeDriverVersionResponse creates a response to parse from GetEdgeDriverVersion response
func CreateGetEdgeDriverVersionResponse() (response *GetEdgeDriverVersionResponse) {
	response = &GetEdgeDriverVersionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
