package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ImportDevice invokes the iot.ImportDevice API synchronously
func (client *Client) ImportDevice(request *ImportDeviceRequest) (response *ImportDeviceResponse, err error) {
	response = CreateImportDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// ImportDeviceWithChan invokes the iot.ImportDevice API asynchronously
func (client *Client) ImportDeviceWithChan(request *ImportDeviceRequest) (<-chan *ImportDeviceResponse, <-chan error) {
	responseChan := make(chan *ImportDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ImportDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ImportDeviceWithCallback invokes the iot.ImportDevice API asynchronously
func (client *Client) ImportDeviceWithCallback(request *ImportDeviceRequest, callback func(response *ImportDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ImportDeviceResponse
		var err error
		defer close(result)
		response, err = client.ImportDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ImportDeviceRequest is the request struct for api ImportDevice
type ImportDeviceRequest struct {
	*requests.RpcRequest
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	Nickname      string `position:"Query" name:"Nickname"`
	Sn            string `position:"Query" name:"Sn"`
	DeviceSecret  string `position:"Query" name:"DeviceSecret"`
	ProductKey    string `position:"Query" name:"ProductKey"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
	DeviceName    string `position:"Query" name:"DeviceName"`
}

// ImportDeviceResponse is the response struct for api ImportDevice
type ImportDeviceResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateImportDeviceRequest creates a request to invoke ImportDevice API
func CreateImportDeviceRequest() (request *ImportDeviceRequest) {
	request = &ImportDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "ImportDevice", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateImportDeviceResponse creates a response to parse from ImportDevice response
func CreateImportDeviceResponse() (response *ImportDeviceResponse) {
	response = &ImportDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
