package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListPowerStation invokes the iot.ListPowerStation API synchronously
func (client *Client) ListPowerStation(request *ListPowerStationRequest) (response *ListPowerStationResponse, err error) {
	response = CreateListPowerStationResponse()
	err = client.DoAction(request, response)
	return
}

// ListPowerStationWithChan invokes the iot.ListPowerStation API asynchronously
func (client *Client) ListPowerStationWithChan(request *ListPowerStationRequest) (<-chan *ListPowerStationResponse, <-chan error) {
	responseChan := make(chan *ListPowerStationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListPowerStation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListPowerStationWithCallback invokes the iot.ListPowerStation API asynchronously
func (client *Client) ListPowerStationWithCallback(request *ListPowerStationRequest, callback func(response *ListPowerStationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListPowerStationResponse
		var err error
		defer close(result)
		response, err = client.ListPowerStation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListPowerStationRequest is the request struct for api ListPowerStation
type ListPowerStationRequest struct {
	*requests.RpcRequest
	IotInstanceId        string           `position:"Query" name:"IotInstanceId"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	AlgorithmInstanceUid string           `position:"Query" name:"AlgorithmInstanceUid"`
	PageNo               requests.Integer `position:"Query" name:"PageNo"`
	PowerStationName     string           `position:"Query" name:"PowerStationName"`
	ApiProduct           string           `position:"Body" name:"ApiProduct"`
	ApiRevision          string           `position:"Body" name:"ApiRevision"`
}

// ListPowerStationResponse is the response struct for api ListPowerStation
type ListPowerStationResponse struct {
	*responses.BaseResponse
	RequestId    string                 `json:"RequestId" xml:"RequestId"`
	Success      bool                   `json:"Success" xml:"Success"`
	Code         string                 `json:"Code" xml:"Code"`
	ErrorMessage string                 `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         DataInListPowerStation `json:"Data" xml:"Data"`
}

// CreateListPowerStationRequest creates a request to invoke ListPowerStation API
func CreateListPowerStationRequest() (request *ListPowerStationRequest) {
	request = &ListPowerStationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "ListPowerStation", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListPowerStationResponse creates a response to parse from ListPowerStation response
func CreateListPowerStationResponse() (response *ListPowerStationResponse) {
	response = &ListPowerStationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
