package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PictureSearchPicture invokes the linkvisual.PictureSearchPicture API synchronously
func (client *Client) PictureSearchPicture(request *PictureSearchPictureRequest) (response *PictureSearchPictureResponse, err error) {
	response = CreatePictureSearchPictureResponse()
	err = client.DoAction(request, response)
	return
}

// PictureSearchPictureWithChan invokes the linkvisual.PictureSearchPicture API asynchronously
func (client *Client) PictureSearchPictureWithChan(request *PictureSearchPictureRequest) (<-chan *PictureSearchPictureResponse, <-chan error) {
	responseChan := make(chan *PictureSearchPictureResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PictureSearchPicture(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PictureSearchPictureWithCallback invokes the linkvisual.PictureSearchPicture API asynchronously
func (client *Client) PictureSearchPictureWithCallback(request *PictureSearchPictureRequest, callback func(response *PictureSearchPictureResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PictureSearchPictureResponse
		var err error
		defer close(result)
		response, err = client.PictureSearchPicture(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PictureSearchPictureRequest is the request struct for api PictureSearchPicture
type PictureSearchPictureRequest struct {
	*requests.RpcRequest
	Threshold         requests.Float   `position:"Query" name:"Threshold"`
	SearchPicUrl      string           `position:"Query" name:"SearchPicUrl"`
	StartTime         requests.Integer `position:"Query" name:"StartTime"`
	PictureSearchType requests.Integer `position:"Query" name:"PictureSearchType"`
	PageSize          requests.Integer `position:"Query" name:"PageSize"`
	EndTime           requests.Integer `position:"Query" name:"EndTime"`
	CurrentPage       requests.Integer `position:"Query" name:"CurrentPage"`
	ContainPicUrl     requests.Boolean `position:"Query" name:"ContainPicUrl"`
	ApiProduct        string           `position:"Body" name:"ApiProduct"`
	ApiRevision       string           `position:"Body" name:"ApiRevision"`
	AppInstanceId     string           `position:"Query" name:"AppInstanceId"`
}

// PictureSearchPictureResponse is the response struct for api PictureSearchPicture
type PictureSearchPictureResponse struct {
	*responses.BaseResponse
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreatePictureSearchPictureRequest creates a request to invoke PictureSearchPicture API
func CreatePictureSearchPictureRequest() (request *PictureSearchPictureRequest) {
	request = &PictureSearchPictureRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "PictureSearchPicture", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreatePictureSearchPictureResponse creates a response to parse from PictureSearchPicture response
func CreatePictureSearchPictureResponse() (response *PictureSearchPictureResponse) {
	response = &PictureSearchPictureResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
