package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteEdgeTranscodeJob invokes the live.DeleteEdgeTranscodeJob API synchronously
func (client *Client) DeleteEdgeTranscodeJob(request *DeleteEdgeTranscodeJobRequest) (response *DeleteEdgeTranscodeJobResponse, err error) {
	response = CreateDeleteEdgeTranscodeJobResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteEdgeTranscodeJobWithChan invokes the live.DeleteEdgeTranscodeJob API asynchronously
func (client *Client) DeleteEdgeTranscodeJobWithChan(request *DeleteEdgeTranscodeJobRequest) (<-chan *DeleteEdgeTranscodeJobResponse, <-chan error) {
	responseChan := make(chan *DeleteEdgeTranscodeJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteEdgeTranscodeJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteEdgeTranscodeJobWithCallback invokes the live.DeleteEdgeTranscodeJob API asynchronously
func (client *Client) DeleteEdgeTranscodeJobWithCallback(request *DeleteEdgeTranscodeJobRequest, callback func(response *DeleteEdgeTranscodeJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteEdgeTranscodeJobResponse
		var err error
		defer close(result)
		response, err = client.DeleteEdgeTranscodeJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteEdgeTranscodeJobRequest is the request struct for api DeleteEdgeTranscodeJob
type DeleteEdgeTranscodeJobRequest struct {
	*requests.RpcRequest
	JobId     string           `position:"Query" name:"JobId"`
	ClusterId string           `position:"Query" name:"ClusterId"`
	OwnerId   requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteEdgeTranscodeJobResponse is the response struct for api DeleteEdgeTranscodeJob
type DeleteEdgeTranscodeJobResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteEdgeTranscodeJobRequest creates a request to invoke DeleteEdgeTranscodeJob API
func CreateDeleteEdgeTranscodeJobRequest() (request *DeleteEdgeTranscodeJobRequest) {
	request = &DeleteEdgeTranscodeJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DeleteEdgeTranscodeJob", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteEdgeTranscodeJobResponse creates a response to parse from DeleteEdgeTranscodeJob response
func CreateDeleteEdgeTranscodeJobResponse() (response *DeleteEdgeTranscodeJobResponse) {
	response = &DeleteEdgeTranscodeJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
