package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteLiveDelayConfig invokes the live.DeleteLiveDelayConfig API synchronously
func (client *Client) DeleteLiveDelayConfig(request *DeleteLiveDelayConfigRequest) (response *DeleteLiveDelayConfigResponse, err error) {
	response = CreateDeleteLiveDelayConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteLiveDelayConfigWithChan invokes the live.DeleteLiveDelayConfig API asynchronously
func (client *Client) DeleteLiveDelayConfigWithChan(request *DeleteLiveDelayConfigRequest) (<-chan *DeleteLiveDelayConfigResponse, <-chan error) {
	responseChan := make(chan *DeleteLiveDelayConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteLiveDelayConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteLiveDelayConfigWithCallback invokes the live.DeleteLiveDelayConfig API asynchronously
func (client *Client) DeleteLiveDelayConfigWithCallback(request *DeleteLiveDelayConfigRequest, callback func(response *DeleteLiveDelayConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteLiveDelayConfigResponse
		var err error
		defer close(result)
		response, err = client.DeleteLiveDelayConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteLiveDelayConfigRequest is the request struct for api DeleteLiveDelayConfig
type DeleteLiveDelayConfigRequest struct {
	*requests.RpcRequest
	Stream  string           `position:"Query" name:"Stream"`
	App     string           `position:"Query" name:"App"`
	OwnerId requests.Integer `position:"Query" name:"OwnerId"`
	Domain  string           `position:"Query" name:"Domain"`
}

// DeleteLiveDelayConfigResponse is the response struct for api DeleteLiveDelayConfig
type DeleteLiveDelayConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteLiveDelayConfigRequest creates a request to invoke DeleteLiveDelayConfig API
func CreateDeleteLiveDelayConfigRequest() (request *DeleteLiveDelayConfigRequest) {
	request = &DeleteLiveDelayConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DeleteLiveDelayConfig", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteLiveDelayConfigResponse creates a response to parse from DeleteLiveDelayConfig response
func CreateDeleteLiveDelayConfigResponse() (response *DeleteLiveDelayConfigResponse) {
	response = &DeleteLiveDelayConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
