package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLiveStreamAuthChecking invokes the live.DescribeLiveStreamAuthChecking API synchronously
func (client *Client) DescribeLiveStreamAuthChecking(request *DescribeLiveStreamAuthCheckingRequest) (response *DescribeLiveStreamAuthCheckingResponse, err error) {
	response = CreateDescribeLiveStreamAuthCheckingResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLiveStreamAuthCheckingWithChan invokes the live.DescribeLiveStreamAuthChecking API asynchronously
func (client *Client) DescribeLiveStreamAuthCheckingWithChan(request *DescribeLiveStreamAuthCheckingRequest) (<-chan *DescribeLiveStreamAuthCheckingResponse, <-chan error) {
	responseChan := make(chan *DescribeLiveStreamAuthCheckingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLiveStreamAuthChecking(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLiveStreamAuthCheckingWithCallback invokes the live.DescribeLiveStreamAuthChecking API asynchronously
func (client *Client) DescribeLiveStreamAuthCheckingWithCallback(request *DescribeLiveStreamAuthCheckingRequest, callback func(response *DescribeLiveStreamAuthCheckingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLiveStreamAuthCheckingResponse
		var err error
		defer close(result)
		response, err = client.DescribeLiveStreamAuthChecking(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLiveStreamAuthCheckingRequest is the request struct for api DescribeLiveStreamAuthChecking
type DescribeLiveStreamAuthCheckingRequest struct {
	*requests.RpcRequest
	DomainName string           `position:"Query" name:"DomainName"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
	Url        string           `position:"Query" name:"Url"`
}

// DescribeLiveStreamAuthCheckingResponse is the response struct for api DescribeLiveStreamAuthChecking
type DescribeLiveStreamAuthCheckingResponse struct {
	*responses.BaseResponse
	Description string `json:"Description" xml:"Description"`
	RequestId   string `json:"RequestId" xml:"RequestId"`
	Status      string `json:"Status" xml:"Status"`
}

// CreateDescribeLiveStreamAuthCheckingRequest creates a request to invoke DescribeLiveStreamAuthChecking API
func CreateDescribeLiveStreamAuthCheckingRequest() (request *DescribeLiveStreamAuthCheckingRequest) {
	request = &DescribeLiveStreamAuthCheckingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLiveStreamAuthChecking", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLiveStreamAuthCheckingResponse creates a response to parse from DescribeLiveStreamAuthChecking response
func CreateDescribeLiveStreamAuthCheckingResponse() (response *DescribeLiveStreamAuthCheckingResponse) {
	response = &DescribeLiveStreamAuthCheckingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
