package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLiveTrafficDomainLog invokes the live.DescribeLiveTrafficDomainLog API synchronously
func (client *Client) DescribeLiveTrafficDomainLog(request *DescribeLiveTrafficDomainLogRequest) (response *DescribeLiveTrafficDomainLogResponse, err error) {
	response = CreateDescribeLiveTrafficDomainLogResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLiveTrafficDomainLogWithChan invokes the live.DescribeLiveTrafficDomainLog API asynchronously
func (client *Client) DescribeLiveTrafficDomainLogWithChan(request *DescribeLiveTrafficDomainLogRequest) (<-chan *DescribeLiveTrafficDomainLogResponse, <-chan error) {
	responseChan := make(chan *DescribeLiveTrafficDomainLogResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLiveTrafficDomainLog(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLiveTrafficDomainLogWithCallback invokes the live.DescribeLiveTrafficDomainLog API asynchronously
func (client *Client) DescribeLiveTrafficDomainLogWithCallback(request *DescribeLiveTrafficDomainLogRequest, callback func(response *DescribeLiveTrafficDomainLogResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLiveTrafficDomainLogResponse
		var err error
		defer close(result)
		response, err = client.DescribeLiveTrafficDomainLog(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLiveTrafficDomainLogRequest is the request struct for api DescribeLiveTrafficDomainLog
type DescribeLiveTrafficDomainLogRequest struct {
	*requests.RpcRequest
	StartTime  string           `position:"Query" name:"StartTime"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	DomainName string           `position:"Query" name:"DomainName"`
	EndTime    string           `position:"Query" name:"EndTime"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeLiveTrafficDomainLogResponse is the response struct for api DescribeLiveTrafficDomainLog
type DescribeLiveTrafficDomainLogResponse struct {
	*responses.BaseResponse
	DomainName       string                                         `json:"DomainName" xml:"DomainName"`
	RequestId        string                                         `json:"RequestId" xml:"RequestId"`
	DomainLogDetails DomainLogDetailsInDescribeLiveTrafficDomainLog `json:"DomainLogDetails" xml:"DomainLogDetails"`
}

// CreateDescribeLiveTrafficDomainLogRequest creates a request to invoke DescribeLiveTrafficDomainLog API
func CreateDescribeLiveTrafficDomainLogRequest() (request *DescribeLiveTrafficDomainLogRequest) {
	request = &DescribeLiveTrafficDomainLogRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLiveTrafficDomainLog", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLiveTrafficDomainLogResponse creates a response to parse from DescribeLiveTrafficDomainLog response
func CreateDescribeLiveTrafficDomainLogResponse() (response *DescribeLiveTrafficDomainLogResponse) {
	response = &DescribeLiveTrafficDomainLogResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
