package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetEditingJobInfo invokes the live.GetEditingJobInfo API synchronously
func (client *Client) GetEditingJobInfo(request *GetEditingJobInfoRequest) (response *GetEditingJobInfoResponse, err error) {
	response = CreateGetEditingJobInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetEditingJobInfoWithChan invokes the live.GetEditingJobInfo API asynchronously
func (client *Client) GetEditingJobInfoWithChan(request *GetEditingJobInfoRequest) (<-chan *GetEditingJobInfoResponse, <-chan error) {
	responseChan := make(chan *GetEditingJobInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetEditingJobInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetEditingJobInfoWithCallback invokes the live.GetEditingJobInfo API asynchronously
func (client *Client) GetEditingJobInfoWithCallback(request *GetEditingJobInfoRequest, callback func(response *GetEditingJobInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetEditingJobInfoResponse
		var err error
		defer close(result)
		response, err = client.GetEditingJobInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetEditingJobInfoRequest is the request struct for api GetEditingJobInfo
type GetEditingJobInfoRequest struct {
	*requests.RpcRequest
	CasterId string           `position:"Query" name:"CasterId"`
	OwnerId  requests.Integer `position:"Query" name:"OwnerId"`
	ShowId   string           `position:"Query" name:"ShowId"`
}

// GetEditingJobInfoResponse is the response struct for api GetEditingJobInfo
type GetEditingJobInfoResponse struct {
	*responses.BaseResponse
	CasterId         string `json:"CasterId" xml:"CasterId"`
	EditingTasksInfo string `json:"EditingTasksInfo" xml:"EditingTasksInfo"`
	RequestId        string `json:"RequestId" xml:"RequestId"`
}

// CreateGetEditingJobInfoRequest creates a request to invoke GetEditingJobInfo API
func CreateGetEditingJobInfoRequest() (request *GetEditingJobInfoRequest) {
	request = &GetEditingJobInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "GetEditingJobInfo", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetEditingJobInfoResponse creates a response to parse from GetEditingJobInfo response
func CreateGetEditingJobInfoResponse() (response *GetEditingJobInfoResponse) {
	response = &GetEditingJobInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
