package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetTranscodeTaskStatus invokes the live.GetTranscodeTaskStatus API synchronously
func (client *Client) GetTranscodeTaskStatus(request *GetTranscodeTaskStatusRequest) (response *GetTranscodeTaskStatusResponse, err error) {
	response = CreateGetTranscodeTaskStatusResponse()
	err = client.DoAction(request, response)
	return
}

// GetTranscodeTaskStatusWithChan invokes the live.GetTranscodeTaskStatus API asynchronously
func (client *Client) GetTranscodeTaskStatusWithChan(request *GetTranscodeTaskStatusRequest) (<-chan *GetTranscodeTaskStatusResponse, <-chan error) {
	responseChan := make(chan *GetTranscodeTaskStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetTranscodeTaskStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetTranscodeTaskStatusWithCallback invokes the live.GetTranscodeTaskStatus API asynchronously
func (client *Client) GetTranscodeTaskStatusWithCallback(request *GetTranscodeTaskStatusRequest, callback func(response *GetTranscodeTaskStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetTranscodeTaskStatusResponse
		var err error
		defer close(result)
		response, err = client.GetTranscodeTaskStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetTranscodeTaskStatusRequest is the request struct for api GetTranscodeTaskStatus
type GetTranscodeTaskStatusRequest struct {
	*requests.RpcRequest
	TranscodingTemplate string `position:"Query" name:"TranscodingTemplate"`
	SecurityToken       string `position:"Query" name:"SecurityToken"`
	PushDomain          string `position:"Query" name:"PushDomain"`
	StreamName          string `position:"Query" name:"StreamName"`
	App                 string `position:"Query" name:"App"`
}

// GetTranscodeTaskStatusResponse is the response struct for api GetTranscodeTaskStatus
type GetTranscodeTaskStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateGetTranscodeTaskStatusRequest creates a request to invoke GetTranscodeTaskStatus API
func CreateGetTranscodeTaskStatusRequest() (request *GetTranscodeTaskStatusRequest) {
	request = &GetTranscodeTaskStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "GetTranscodeTaskStatus", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetTranscodeTaskStatusResponse creates a response to parse from GetTranscodeTaskStatus response
func CreateGetTranscodeTaskStatusResponse() (response *GetTranscodeTaskStatusResponse) {
	response = &GetTranscodeTaskStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
