package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListEdgeTranscodeJob invokes the live.ListEdgeTranscodeJob API synchronously
func (client *Client) ListEdgeTranscodeJob(request *ListEdgeTranscodeJobRequest) (response *ListEdgeTranscodeJobResponse, err error) {
	response = CreateListEdgeTranscodeJobResponse()
	err = client.DoAction(request, response)
	return
}

// ListEdgeTranscodeJobWithChan invokes the live.ListEdgeTranscodeJob API asynchronously
func (client *Client) ListEdgeTranscodeJobWithChan(request *ListEdgeTranscodeJobRequest) (<-chan *ListEdgeTranscodeJobResponse, <-chan error) {
	responseChan := make(chan *ListEdgeTranscodeJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListEdgeTranscodeJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListEdgeTranscodeJobWithCallback invokes the live.ListEdgeTranscodeJob API asynchronously
func (client *Client) ListEdgeTranscodeJobWithCallback(request *ListEdgeTranscodeJobRequest, callback func(response *ListEdgeTranscodeJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListEdgeTranscodeJobResponse
		var err error
		defer close(result)
		response, err = client.ListEdgeTranscodeJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListEdgeTranscodeJobRequest is the request struct for api ListEdgeTranscodeJob
type ListEdgeTranscodeJobRequest struct {
	*requests.RpcRequest
	Type      string           `position:"Query" name:"Type"`
	PageSize  requests.Integer `position:"Query" name:"PageSize"`
	Keyword   string           `position:"Query" name:"Keyword"`
	ClusterId string           `position:"Query" name:"ClusterId"`
	OwnerId   requests.Integer `position:"Query" name:"OwnerId"`
	PageNo    requests.Integer `position:"Query" name:"PageNo"`
	SortBy    string           `position:"Query" name:"SortBy"`
	Status    requests.Integer `position:"Query" name:"Status"`
}

// ListEdgeTranscodeJobResponse is the response struct for api ListEdgeTranscodeJob
type ListEdgeTranscodeJobResponse struct {
	*responses.BaseResponse
	RequestId  string  `json:"RequestId" xml:"RequestId"`
	TotalCount int     `json:"TotalCount" xml:"TotalCount"`
	JobList    JobList `json:"JobList" xml:"JobList"`
}

// CreateListEdgeTranscodeJobRequest creates a request to invoke ListEdgeTranscodeJob API
func CreateListEdgeTranscodeJobRequest() (request *ListEdgeTranscodeJobRequest) {
	request = &ListEdgeTranscodeJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "ListEdgeTranscodeJob", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListEdgeTranscodeJobResponse creates a response to parse from ListEdgeTranscodeJob response
func CreateListEdgeTranscodeJobResponse() (response *ListEdgeTranscodeJobResponse) {
	response = &ListEdgeTranscodeJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
