package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListMessage invokes the live.ListMessage API synchronously
func (client *Client) ListMessage(request *ListMessageRequest) (response *ListMessageResponse, err error) {
	response = CreateListMessageResponse()
	err = client.DoAction(request, response)
	return
}

// ListMessageWithChan invokes the live.ListMessage API asynchronously
func (client *Client) ListMessageWithChan(request *ListMessageRequest) (<-chan *ListMessageResponse, <-chan error) {
	responseChan := make(chan *ListMessageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListMessage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListMessageWithCallback invokes the live.ListMessage API asynchronously
func (client *Client) ListMessageWithCallback(request *ListMessageRequest, callback func(response *ListMessageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListMessageResponse
		var err error
		defer close(result)
		response, err = client.ListMessage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListMessageRequest is the request struct for api ListMessage
type ListMessageRequest struct {
	*requests.RpcRequest
	SortType requests.Integer `position:"Body" name:"SortType"`
	Type     requests.Integer `position:"Body" name:"Type"`
	PageNum  requests.Integer `position:"Body" name:"PageNum"`
	PageSize requests.Integer `position:"Body" name:"PageSize"`
	GroupId  string           `position:"Body" name:"GroupId"`
	AppId    string           `position:"Body" name:"AppId"`
}

// ListMessageResponse is the response struct for api ListMessage
type ListMessageResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateListMessageRequest creates a request to invoke ListMessage API
func CreateListMessageRequest() (request *ListMessageRequest) {
	request = &ListMessageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "ListMessage", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListMessageResponse creates a response to parse from ListMessage response
func CreateListMessageResponse() (response *ListMessageResponse) {
	response = &ListMessageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
