package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListRtcMPUTaskDetail invokes the live.ListRtcMPUTaskDetail API synchronously
func (client *Client) ListRtcMPUTaskDetail(request *ListRtcMPUTaskDetailRequest) (response *ListRtcMPUTaskDetailResponse, err error) {
	response = CreateListRtcMPUTaskDetailResponse()
	err = client.DoAction(request, response)
	return
}

// ListRtcMPUTaskDetailWithChan invokes the live.ListRtcMPUTaskDetail API asynchronously
func (client *Client) ListRtcMPUTaskDetailWithChan(request *ListRtcMPUTaskDetailRequest) (<-chan *ListRtcMPUTaskDetailResponse, <-chan error) {
	responseChan := make(chan *ListRtcMPUTaskDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListRtcMPUTaskDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListRtcMPUTaskDetailWithCallback invokes the live.ListRtcMPUTaskDetail API asynchronously
func (client *Client) ListRtcMPUTaskDetailWithCallback(request *ListRtcMPUTaskDetailRequest, callback func(response *ListRtcMPUTaskDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListRtcMPUTaskDetailResponse
		var err error
		defer close(result)
		response, err = client.ListRtcMPUTaskDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListRtcMPUTaskDetailRequest is the request struct for api ListRtcMPUTaskDetail
type ListRtcMPUTaskDetailRequest struct {
	*requests.RpcRequest
	PageNo   requests.Integer `position:"Query" name:"PageNo"`
	AppId    string           `position:"Query" name:"AppId"`
	PageSize requests.Integer `position:"Query" name:"PageSize"`
	TaskId   string           `position:"Query" name:"TaskId"`
}

// ListRtcMPUTaskDetailResponse is the response struct for api ListRtcMPUTaskDetail
type ListRtcMPUTaskDetailResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	MPUTasks  []MpuTask `json:"MPUTasks" xml:"MPUTasks"`
}

// CreateListRtcMPUTaskDetailRequest creates a request to invoke ListRtcMPUTaskDetail API
func CreateListRtcMPUTaskDetailRequest() (request *ListRtcMPUTaskDetailRequest) {
	request = &ListRtcMPUTaskDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "ListRtcMPUTaskDetail", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListRtcMPUTaskDetailResponse creates a response to parse from ListRtcMPUTaskDetail response
func CreateListRtcMPUTaskDetailResponse() (response *ListRtcMPUTaskDetailResponse) {
	response = &ListRtcMPUTaskDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
