package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveShowFromShowList invokes the live.RemoveShowFromShowList API synchronously
func (client *Client) RemoveShowFromShowList(request *RemoveShowFromShowListRequest) (response *RemoveShowFromShowListResponse, err error) {
	response = CreateRemoveShowFromShowListResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveShowFromShowListWithChan invokes the live.RemoveShowFromShowList API asynchronously
func (client *Client) RemoveShowFromShowListWithChan(request *RemoveShowFromShowListRequest) (<-chan *RemoveShowFromShowListResponse, <-chan error) {
	responseChan := make(chan *RemoveShowFromShowListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveShowFromShowList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveShowFromShowListWithCallback invokes the live.RemoveShowFromShowList API asynchronously
func (client *Client) RemoveShowFromShowListWithCallback(request *RemoveShowFromShowListRequest, callback func(response *RemoveShowFromShowListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveShowFromShowListResponse
		var err error
		defer close(result)
		response, err = client.RemoveShowFromShowList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveShowFromShowListRequest is the request struct for api RemoveShowFromShowList
type RemoveShowFromShowListRequest struct {
	*requests.RpcRequest
	IsBatchMode requests.Boolean `position:"Query" name:"isBatchMode"`
	ShowIdList  *[]string        `position:"Query" name:"showIdList"  type:"Repeated"`
	CasterId    string           `position:"Query" name:"CasterId"`
	OwnerId     requests.Integer `position:"Query" name:"OwnerId"`
	ShowId      string           `position:"Query" name:"ShowId"`
}

// RemoveShowFromShowListResponse is the response struct for api RemoveShowFromShowList
type RemoveShowFromShowListResponse struct {
	*responses.BaseResponse
	RequestId         string `json:"RequestId" xml:"RequestId"`
	ShowId            string `json:"ShowId" xml:"ShowId"`
	FailedList        string `json:"failedList" xml:"failedList"`
	SuccessfulShowIds string `json:"successfulShowIds" xml:"successfulShowIds"`
}

// CreateRemoveShowFromShowListRequest creates a request to invoke RemoveShowFromShowList API
func CreateRemoveShowFromShowListRequest() (request *RemoveShowFromShowListRequest) {
	request = &RemoveShowFromShowListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "RemoveShowFromShowList", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRemoveShowFromShowListResponse creates a response to parse from RemoveShowFromShowList response
func CreateRemoveShowFromShowListResponse() (response *RemoveShowFromShowListResponse) {
	response = &RemoveShowFromShowListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
