package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateLiveAISubtitle invokes the live.UpdateLiveAISubtitle API synchronously
func (client *Client) UpdateLiveAISubtitle(request *UpdateLiveAISubtitleRequest) (response *UpdateLiveAISubtitleResponse, err error) {
	response = CreateUpdateLiveAISubtitleResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateLiveAISubtitleWithChan invokes the live.UpdateLiveAISubtitle API asynchronously
func (client *Client) UpdateLiveAISubtitleWithChan(request *UpdateLiveAISubtitleRequest) (<-chan *UpdateLiveAISubtitleResponse, <-chan error) {
	responseChan := make(chan *UpdateLiveAISubtitleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateLiveAISubtitle(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateLiveAISubtitleWithCallback invokes the live.UpdateLiveAISubtitle API asynchronously
func (client *Client) UpdateLiveAISubtitleWithCallback(request *UpdateLiveAISubtitleRequest, callback func(response *UpdateLiveAISubtitleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateLiveAISubtitleResponse
		var err error
		defer close(result)
		response, err = client.UpdateLiveAISubtitle(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateLiveAISubtitleRequest is the request struct for api UpdateLiveAISubtitle
type UpdateLiveAISubtitleRequest struct {
	*requests.RpcRequest
	SrcLanguage           string           `position:"Query" name:"SrcLanguage"`
	Description           string           `position:"Query" name:"Description"`
	FontName              string           `position:"Query" name:"FontName"`
	SubtitleName          string           `position:"Query" name:"SubtitleName"`
	FontSizeNormalized    requests.Float   `position:"Query" name:"FontSizeNormalized"`
	FontColor             string           `position:"Query" name:"FontColor"`
	ShowSourceLan         requests.Boolean `position:"Query" name:"ShowSourceLan"`
	PositionNormalized    *[]string        `position:"Query" name:"PositionNormalized"  type:"Json"`
	BorderWidthNormalized requests.Float   `position:"Query" name:"BorderWidthNormalized"`
	MaxLines              requests.Integer `position:"Query" name:"MaxLines"`
	Height                string           `position:"Query" name:"Height"`
	WordPerLine           requests.Integer `position:"Query" name:"WordPerLine"`
	OwnerId               requests.Integer `position:"Query" name:"OwnerId"`
	BgWidthNormalized     requests.Float   `position:"Query" name:"BgWidthNormalized"`
	BgColor               string           `position:"Query" name:"BgColor"`
	DstLanguage           string           `position:"Query" name:"DstLanguage"`
	Width                 string           `position:"Query" name:"Width"`
	SubtitleId            string           `position:"Query" name:"SubtitleId"`
}

// UpdateLiveAISubtitleResponse is the response struct for api UpdateLiveAISubtitle
type UpdateLiveAISubtitleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateLiveAISubtitleRequest creates a request to invoke UpdateLiveAISubtitle API
func CreateUpdateLiveAISubtitleRequest() (request *UpdateLiveAISubtitleRequest) {
	request = &UpdateLiveAISubtitleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "UpdateLiveAISubtitle", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateLiveAISubtitleResponse creates a response to parse from UpdateLiveAISubtitle response
func CreateUpdateLiveAISubtitleResponse() (response *UpdateLiveAISubtitleResponse) {
	response = &UpdateLiveAISubtitleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
