package lto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeStatMemberDeviceInfo invokes the lto.DescribeStatMemberDeviceInfo API synchronously
func (client *Client) DescribeStatMemberDeviceInfo(request *DescribeStatMemberDeviceInfoRequest) (response *DescribeStatMemberDeviceInfoResponse, err error) {
	response = CreateDescribeStatMemberDeviceInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeStatMemberDeviceInfoWithChan invokes the lto.DescribeStatMemberDeviceInfo API asynchronously
func (client *Client) DescribeStatMemberDeviceInfoWithChan(request *DescribeStatMemberDeviceInfoRequest) (<-chan *DescribeStatMemberDeviceInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeStatMemberDeviceInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeStatMemberDeviceInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeStatMemberDeviceInfoWithCallback invokes the lto.DescribeStatMemberDeviceInfo API asynchronously
func (client *Client) DescribeStatMemberDeviceInfoWithCallback(request *DescribeStatMemberDeviceInfoRequest, callback func(response *DescribeStatMemberDeviceInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeStatMemberDeviceInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeStatMemberDeviceInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeStatMemberDeviceInfoRequest is the request struct for api DescribeStatMemberDeviceInfo
type DescribeStatMemberDeviceInfoRequest struct {
	*requests.RpcRequest
}

// DescribeStatMemberDeviceInfoResponse is the response struct for api DescribeStatMemberDeviceInfo
type DescribeStatMemberDeviceInfoResponse struct {
	*responses.BaseResponse
	Code           string     `json:"Code" xml:"Code"`
	HttpStatusCode int        `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string     `json:"Message" xml:"Message"`
	RequestId      string     `json:"RequestId" xml:"RequestId"`
	Success        bool       `json:"Success" xml:"Success"`
	Data           []DataItem `json:"Data" xml:"Data"`
}

// CreateDescribeStatMemberDeviceInfoRequest creates a request to invoke DescribeStatMemberDeviceInfo API
func CreateDescribeStatMemberDeviceInfoRequest() (request *DescribeStatMemberDeviceInfoRequest) {
	request = &DescribeStatMemberDeviceInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lto", "2021-07-07", "DescribeStatMemberDeviceInfo", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeStatMemberDeviceInfoResponse creates a response to parse from DescribeStatMemberDeviceInfo response
func CreateDescribeStatMemberDeviceInfoResponse() (response *DescribeStatMemberDeviceInfoResponse) {
	response = &DescribeStatMemberDeviceInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
