package lto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAllAdmin invokes the lto.ListAllAdmin API synchronously
func (client *Client) ListAllAdmin(request *ListAllAdminRequest) (response *ListAllAdminResponse, err error) {
	response = CreateListAllAdminResponse()
	err = client.DoAction(request, response)
	return
}

// ListAllAdminWithChan invokes the lto.ListAllAdmin API asynchronously
func (client *Client) ListAllAdminWithChan(request *ListAllAdminRequest) (<-chan *ListAllAdminResponse, <-chan error) {
	responseChan := make(chan *ListAllAdminResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAllAdmin(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAllAdminWithCallback invokes the lto.ListAllAdmin API asynchronously
func (client *Client) ListAllAdminWithCallback(request *ListAllAdminRequest, callback func(response *ListAllAdminResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAllAdminResponse
		var err error
		defer close(result)
		response, err = client.ListAllAdmin(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAllAdminRequest is the request struct for api ListAllAdmin
type ListAllAdminRequest struct {
	*requests.RpcRequest
}

// ListAllAdminResponse is the response struct for api ListAllAdmin
type ListAllAdminResponse struct {
	*responses.BaseResponse
	Code           string      `json:"Code" xml:"Code"`
	HttpStatusCode int         `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string      `json:"Message" xml:"Message"`
	RequestId      string      `json:"RequestId" xml:"RequestId"`
	Success        bool        `json:"Success" xml:"Success"`
	Data           []AdminInfo `json:"Data" xml:"Data"`
}

// CreateListAllAdminRequest creates a request to invoke ListAllAdmin API
func CreateListAllAdminRequest() (request *ListAllAdminRequest) {
	request = &ListAllAdminRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lto", "2021-07-07", "ListAllAdmin", "", "")
	request.Method = requests.POST
	return
}

// CreateListAllAdminResponse creates a response to parse from ListAllAdmin response
func CreateListAllAdminResponse() (response *ListAllAdminResponse) {
	response = &ListAllAdminResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
